// Good.cpp : Implementation of CGood
#include "stdafx.h"
#include "TestObject.h"
#include "Good.h"
#include "ErrorHelper.h"

/////////////////////////////////////////////////////////////////////////////
// CGood

STDMETHODIMP CGood::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IGood
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CGood::get_One(long *pVal)
{
	*pVal = 1;

	return S_OK;
}

STDMETHODIMP CGood::put_One(long newVal)
{
	if( newVal != 1 )
	{
		return SetError("Good.One", "can't set One to anything but 1");
	}

	return S_OK;
}

STDMETHODIMP CGood::get_Two(BSTR *pVal)
{
	_bstr_t tmp = "Two";
	*pVal = tmp.copy();

	return S_OK;
}

STDMETHODIMP CGood::put_Two(BSTR newVal)
{
	_bstr_t tmp = newVal;
	if( tmp != _bstr_t("Two") )
	{ 
		return SetError("Good.Two", "can't set Two to anything but 'Two'");
	}

	return S_OK;
}

STDMETHODIMP CGood::Add(long a, long b, long* pRes)
{
	if( !pRes )
		return E_POINTER;
	*pRes = a + b;

	return S_OK;
}
