' Bad object tests - identical to TestObjectGood, except the object being tested has been changed

dim obj
ScriptUnit.Timeout = 5	

sub Setup
	set obj = CreateObject(	"TestObject.Bad" )
	Assert.IsSomething obj
end sub

sub Teardown
	set obj = Nothing
end sub



sub TestOne_Get
	Assert.IsEqual obj.One, 1, "obj.One does not return 1"	
end sub

sub TestOne_Set
	obj.One = 1
	
	Assert.ExpectError
	obj.One = 2	
end sub


sub TestTwo_Get
	Assert.IsEqual obj.Two, "Two", "obj.Two does not return 'Two'"	
end sub

sub TestTwo_Set
	obj.Two = "Two"
	
	Assert.ExpectError
	obj.Two = "Three"	
end sub


sub TestAdd_1_1
	x = obj.Add(1,1)
	Assert.IsEqual x, 2, "obj.Add(1,1) does not return 2"	
end sub

sub TestAdd_1_0
	x = obj.Add(1,0)
	y = obj.Add(0,1)
	Assert.IsEqual x, 1, "obj.Add(1,0) does not return 1"	
	Assert.IsEqual y, 1, "obj.Add(0,1) does not return 1"	
end sub

sub TestAdd_2_2
	x = obj.Add(2,2)
	Assert.IsEqual x, 4, "obj.Add(2,2) does not return 4"
end sub

sub TestAdd_3_2
	x = obj.Add(3,2)
	Assert.IsEqual x, 5, "obj.Add(3,2) does not return 5"
	x = obj.Add(2,3)
	Assert.IsEqual x, 5, "obj.Add(2,3) does not return 5"
end sub
