import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class Main {
    public static void main(String[] args) {
        // Read data from authors.csv file
        List<Author> authors;
        try {
            authors = CSV.read("D:/csv/authors.csv");
        } catch (IOException e) {
            System.err.println(e.getMessage());
            return;
        }

        // Connect to the SQL Server
        try (var connection = SQLServerConnection.connect()) {
            var authorDB = new AuthorDB(connection);
            // insert authors
            authorDB.insertMany(authors);
        } catch (SQLException | DBException e) {
            System.err.println(e.getMessage());
        }
    }
}