import java.sql.Date;
import java.sql.SQLException;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class BookDB {
    private final Connection connection;

    public BookDB(Connection connection) {
        this.connection = connection;
    }

    private Book createBookFrom(ResultSet rs) throws SQLException {
        return new Book(
                rs.getInt("BookID"),
                rs.getString("Title"),
                rs.getString("Publisher"),
                rs.getString("ISBN"),
                rs.getDate("PublishedDate").toLocalDate()
        );
    }

    public List<Book> findByPublishedDate(LocalDate fromDate, LocalDate toDate) throws DBException {
        var books = new ArrayList<Book>();
        String sql = "{CALL GetBooksByPublishedDate(?, ?)}";

        try (var stmt = connection.prepareCall(sql)) {

            stmt.setDate(1, Date.valueOf(fromDate));
            stmt.setDate(2, Date.valueOf(toDate));

            try (var rs = stmt.executeQuery()) {
                while (rs.next()) {
                    books.add(createBookFrom(rs));
                }
                return books;
            }

        } catch (SQLException e) {
            throw new DBException(e.getMessage());
        }

    }
}