/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.types;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.tokensregex.types.Expressions;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.util.ErasureUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tags
implements Serializable {
    Map<String, Value> tags;
    private static final long serialVersionUID = 2L;

    public Tags(String ... tags) {
        if (tags != null) {
            this.tags = new HashMap<String, Value>();
            for (String tag : tags) {
                this.tags.put(tag, null);
            }
        }
    }

    public Collection<String> getTags() {
        return this.tags.keySet();
    }

    public boolean hasTag(String tag) {
        return this.tags != null ? this.tags.containsKey(tag) : false;
    }

    public void setTag(String tag, Value v) {
        if (this.tags == null) {
            this.tags = new HashMap<String, Value>(1);
        }
        this.tags.put(tag, v);
    }

    public void addTag(String tag, Value v) {
        if (this.tags == null) {
            this.tags = new HashMap<String, Value>(1);
        }
        List<Value> tagList = null;
        if (this.tags.containsKey(tag)) {
            Value oldValue = this.tags.get(tag);
            if ("LIST".equals(oldValue.getType())) {
                tagList = (List)ErasureUtils.uncheckedCast(oldValue.get());
            } else {
                tagList = new ArrayList();
                tagList.add(oldValue);
                this.tags.put(tag, Expressions.createValue("LIST", tagList, new String[0]));
            }
        } else {
            tagList = new ArrayList<Value>();
            this.tags.put(tag, Expressions.createValue("LIST", tagList, new String[0]));
        }
        tagList.add(v);
    }

    public void removeTag(String tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
        }
    }

    public Value getTag(String tag) {
        return this.tags != null ? this.tags.get(tag) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tags)) {
            return false;
        }
        Tags tags1 = (Tags)o;
        return !(this.tags != null ? !this.tags.equals(tags1.tags) : tags1.tags != null);
    }

    public int hashCode() {
        return this.tags != null ? this.tags.hashCode() : 0;
    }

    public static class TagsAnnotation
    implements CoreAnnotation<Tags> {
        @Override
        public Class<Tags> getType() {
            return Tags.class;
        }
    }
}

