/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import java.io.IOException;
import java.util.function.Predicate;

public class FilteringTreeReader
implements TreeReader {
    private TreeReader tr;
    private Predicate<Tree> f;

    public FilteringTreeReader(TreeReader tr, Predicate<Tree> f) {
        this.tr = tr;
        this.f = f;
    }

    @Override
    public Tree readTree() throws IOException {
        Tree t;
        while ((t = this.tr.readTree()) != null && !this.f.test(t)) {
        }
        return t;
    }

    @Override
    public void close() throws IOException {
        this.tr.close();
    }
}

