/* The following code was generated by JFlex 1.6.1 */

package edu.stanford.nlp.international.arabic.process;

import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;

/**
 * Tokenizer for UTF-8 Arabic. Supports raw text and both sections
 * (vocalized and unvocalized) of the ATB.
 *
 * @author Spence Green
 */


class ArabicLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\40\1\2\1\3\1\4\1\1\22\0\1\40\1\15\1\41"+
    "\1\7\1\46\2\7\1\46\2\41\1\7\1\26\1\14\1\20\1\6"+
    "\1\37\12\47\1\36\1\46\1\41\1\46\1\41\1\15\1\101\1\54"+
    "\1\105\1\57\1\75\1\67\1\54\1\73\1\50\3\54\1\103\1\63"+
    "\1\65\1\61\1\52\1\54\1\71\1\55\1\51\1\77\1\54\1\53"+
    "\3\54\1\21\1\13\1\25\1\46\1\17\1\46\1\44\1\104\1\56"+
    "\1\74\1\66\1\44\1\72\1\32\3\44\1\102\1\62\1\64\1\60"+
    "\1\34\1\44\1\70\1\45\1\33\1\76\1\44\1\43\3\44\1\42"+
    "\1\41\1\42\1\7\6\0\1\3\32\0\1\100\11\7\1\30\2\7"+
    "\1\30\7\7\1\30\4\7\1\30\5\7\27\27\1\0\37\27\1\0"+
    "\207\27\1\35\267\27\31\27\162\27\4\27\14\27\16\27\5\27\7\27"+
    "\1\27\1\27\1\27\201\27\5\27\1\27\2\27\2\27\4\27\1\0"+
    "\1\27\4\0\2\27\1\27\1\0\3\27\1\0\1\27\1\0\24\27"+
    "\1\0\54\27\1\27\46\27\1\27\5\27\4\27\202\27\1\0\5\27"+
    "\2\0\105\27\1\27\46\27\12\27\20\27\26\27\12\27\1\0\46\27"+
    "\2\0\1\27\6\27\1\0\47\27\11\0\55\27\1\0\1\27\1\0"+
    "\2\27\1\0\2\27\1\0\1\27\10\0\33\27\5\0\3\27\15\0"+
    "\14\7\1\11\1\12\15\16\5\7\1\27\43\31\1\24\1\31\1\22"+
    "\4\31\4\16\1\23\17\16\1\0\12\10\1\7\2\12\1\7\2\31"+
    "\1\16\143\31\1\7\1\31\17\16\2\31\7\16\2\31\12\10\3\31"+
    "\2\16\1\31\17\0\1\27\1\27\1\27\36\27\35\27\63\27\46\27"+
    "\13\27\1\27\16\0\12\10\41\27\11\27\2\27\4\0\1\27\5\0"+
    "\26\27\4\0\1\27\11\0\1\27\3\0\1\27\27\0\31\27\107\0"+
    "\23\27\115\0\4\27\66\27\2\0\1\27\1\27\21\27\1\0\1\27"+
    "\5\27\2\0\12\27\2\27\2\0\12\10\1\0\20\27\3\27\1\0"+
    "\10\27\2\0\2\27\2\0\26\27\1\0\7\27\1\0\1\27\3\0"+
    "\4\27\2\0\1\27\1\27\7\27\2\0\2\27\2\0\3\27\1\27"+
    "\10\0\1\27\4\0\2\27\1\0\3\27\2\27\2\0\12\10\2\27"+
    "\17\0\3\27\1\0\6\27\4\0\2\27\2\0\26\27\1\0\7\27"+
    "\1\0\2\27\1\0\2\27\1\0\2\27\2\0\1\27\1\0\22\27"+
    "\11\0\4\27\1\0\1\27\7\0\12\10\2\0\3\27\14\0\3\27"+
    "\1\0\11\27\1\0\3\27\1\0\26\27\1\0\7\27\1\0\2\27"+
    "\1\0\5\27\2\0\1\27\1\27\22\27\1\27\17\0\2\27\4\0"+
    "\12\10\25\0\10\27\2\0\2\27\2\0\26\27\1\0\7\27\1\0"+
    "\2\27\1\0\5\27\3\0\1\27\36\0\2\27\1\0\3\27\4\0"+
    "\12\10\1\0\1\27\20\0\1\27\1\27\1\0\6\27\3\0\3\27"+
    "\1\0\4\27\3\0\2\27\1\0\1\27\1\0\2\27\3\0\2\27"+
    "\3\0\3\27\3\0\14\27\4\0\5\27\3\0\3\27\1\0\4\27"+
    "\2\0\1\27\25\0\12\10\21\0\3\27\1\0\10\27\1\0\3\27"+
    "\1\0\27\27\1\0\20\27\3\0\1\27\31\27\1\0\2\27\6\0"+
    "\2\27\4\0\12\10\25\0\10\27\1\0\3\27\1\0\27\27\1\0"+
    "\12\27\1\0\5\27\3\0\1\27\40\0\1\27\1\0\2\27\4\0"+
    "\12\10\1\0\2\27\22\0\10\27\1\0\3\27\1\0\51\27\2\0"+
    "\1\27\7\27\1\0\3\27\5\0\1\27\21\0\2\27\4\0\12\10"+
    "\12\0\6\27\5\0\22\27\3\0\30\27\1\0\11\27\1\0\1\27"+
    "\2\0\7\27\37\0\12\10\21\0\57\27\1\27\1\27\2\27\7\27"+
    "\5\0\7\27\10\27\1\0\12\10\47\0\2\27\1\0\1\27\2\0"+
    "\2\27\1\0\1\27\2\0\1\27\6\0\4\27\1\0\7\27\1\0"+
    "\3\27\1\0\1\27\1\0\1\27\2\0\2\27\1\0\4\27\1\27"+
    "\2\27\11\27\1\27\2\0\5\27\1\0\1\27\1\0\6\27\2\0"+
    "\12\10\2\0\4\27\40\0\1\27\37\0\12\10\26\0\10\27\1\0"+
    "\44\27\33\0\5\27\163\0\53\27\24\0\1\27\12\10\6\0\6\27"+
    "\4\0\4\27\3\0\1\27\3\0\2\27\7\0\3\27\4\0\15\27"+
    "\14\0\1\27\1\0\12\10\6\0\46\27\1\0\1\27\5\0\1\27"+
    "\2\0\53\27\1\0\u014d\27\1\0\4\27\2\0\7\27\1\0\1\27"+
    "\1\0\4\27\2\0\51\27\1\0\4\27\2\0\41\27\1\0\4\27"+
    "\2\0\7\27\1\0\1\27\1\0\4\27\2\0\17\27\1\0\71\27"+
    "\1\0\4\27\2\0\103\27\45\0\20\27\20\0\125\27\14\0\u026c\27"+
    "\2\0\21\27\1\0\32\27\5\0\113\27\6\0\10\27\7\0\15\27"+
    "\1\0\4\27\16\0\22\27\16\0\22\27\16\0\15\27\1\0\3\27"+
    "\17\0\64\27\43\0\1\27\4\0\1\27\3\0\12\10\46\0\12\10"+
    "\6\0\130\27\10\0\51\27\1\0\1\27\5\0\106\27\12\0\37\27"+
    "\47\0\12\10\36\27\2\0\5\27\13\0\54\27\25\0\7\27\10\0"+
    "\12\10\46\0\27\27\11\0\65\27\53\0\12\10\6\0\12\10\15\0"+
    "\1\27\135\0\57\27\21\0\7\27\4\0\12\10\51\0\36\27\15\0"+
    "\2\27\12\10\54\27\32\0\44\27\34\0\12\10\3\0\3\27\12\10"+
    "\44\27\153\0\4\27\1\0\4\27\3\0\2\27\11\0\300\27\100\0"+
    "\u0116\27\2\0\6\27\2\0\46\27\2\0\6\27\2\0\10\27\1\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\37\27\2\0\65\27\1\0"+
    "\7\27\1\0\1\27\3\0\3\27\1\0\7\27\3\0\4\27\2\0"+
    "\6\27\4\0\15\27\5\0\3\27\1\0\7\27\3\0\13\5\5\0"+
    "\30\7\1\3\1\3\5\0\1\5\57\7\22\0\1\27\15\0\1\27"+
    "\20\0\15\27\3\0\26\7\114\0\1\27\4\0\1\27\2\0\12\27"+
    "\1\0\1\27\3\0\5\27\6\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\1\0\13\27\2\0\4\27\5\0\5\27\4\0\1\27"+
    "\64\0\2\27\u0a7b\0\57\27\1\0\57\27\1\0\205\27\6\0\4\27"+
    "\3\0\2\27\14\0\46\27\1\0\1\27\5\0\1\27\2\0\70\27"+
    "\7\0\1\27\20\0\27\27\11\0\7\27\1\0\7\27\1\0\7\27"+
    "\1\0\7\27\1\0\7\27\1\0\7\27\1\0\7\27\1\0\7\27"+
    "\117\0\1\7\1\27\u01d0\0\1\5\4\0\2\27\52\0\5\27\5\0"+
    "\2\27\4\0\126\27\6\0\3\27\1\0\132\27\1\0\4\27\5\0"+
    "\51\27\3\0\136\27\21\0\33\27\65\0\20\27\u0200\0\u19b6\27\112\0"+
    "\u51cd\27\63\0\u048d\27\103\0\56\27\2\0\u010d\27\3\0\20\27\12\10"+
    "\2\27\24\0\57\27\20\0\37\27\2\0\106\27\61\0\11\27\2\0"+
    "\147\27\2\0\4\27\1\0\36\27\2\0\2\27\105\0\13\27\1\0"+
    "\3\27\1\0\4\27\1\0\27\27\35\0\64\27\16\0\62\27\34\0"+
    "\12\10\30\0\6\27\3\0\1\27\4\0\12\10\34\27\12\0\27\27"+
    "\31\0\35\27\7\0\57\27\34\0\1\27\12\10\6\0\5\27\1\0"+
    "\12\27\12\10\5\27\1\0\51\27\27\0\3\27\1\0\10\27\4\0"+
    "\12\10\6\0\27\27\3\0\1\27\3\0\62\27\1\0\1\27\3\0"+
    "\2\27\2\0\5\27\2\0\1\27\1\0\1\27\30\0\3\27\2\0"+
    "\13\27\7\0\3\27\14\0\6\27\2\0\6\27\2\0\6\27\11\0"+
    "\7\27\1\0\7\27\1\0\53\27\1\0\4\27\4\0\2\27\132\0"+
    "\43\27\15\0\12\10\6\0\u2ba4\27\14\0\27\27\4\0\61\27\u2104\0"+
    "\u016e\27\2\0\152\27\46\0\7\27\14\0\5\27\5\0\1\27\1\0"+
    "\12\27\1\0\15\27\1\0\5\27\1\0\1\27\1\0\2\27\1\0"+
    "\2\27\1\0\154\27\41\0\u016b\27\22\0\100\27\2\0\66\27\50\0"+
    "\14\27\164\0\5\27\1\0\207\27\23\0\12\10\7\0\32\27\6\0"+
    "\32\27\13\0\131\27\3\0\6\27\2\0\6\27\2\0\6\27\2\0"+
    "\3\27\43\0\14\27\1\0\32\27\1\0\23\27\1\0\2\27\1\0"+
    "\17\27\2\0\16\27\42\0\173\27\u0185\0\35\27\3\0\61\27\57\0"+
    "\40\27\20\0\21\27\1\0\10\27\6\0\46\27\12\0\36\27\2\0"+
    "\44\27\4\0\10\27\60\0\236\27\2\0\12\10\126\0\50\27\10\0"+
    "\64\27\234\0\u0137\27\11\0\26\27\12\0\10\27\230\0\6\27\2\0"+
    "\1\27\1\0\54\27\1\0\2\27\3\0\1\27\2\0\27\27\12\0"+
    "\27\27\11\0\37\27\141\0\26\27\12\0\32\27\106\0\70\27\6\0"+
    "\2\27\100\0\1\27\17\0\4\27\1\0\3\27\1\0\33\27\54\0"+
    "\35\27\3\0\35\27\43\0\10\27\1\0\34\27\33\0\66\27\12\0"+
    "\26\27\12\0\23\27\15\0\22\27\156\0\111\27\u03ba\0\65\27\56\0"+
    "\12\10\23\0\55\27\40\0\31\27\7\0\12\10\11\0\44\27\17\0"+
    "\12\10\20\0\43\27\3\0\1\27\14\0\60\27\16\0\4\27\13\0"+
    "\12\10\1\27\45\0\22\27\1\0\31\27\204\0\57\27\21\0\12\10"+
    "\13\0\10\27\2\0\2\27\2\0\26\27\1\0\7\27\1\0\2\27"+
    "\1\0\5\27\3\0\1\27\37\0\5\27\u011e\0\60\27\24\0\2\27"+
    "\1\0\1\27\10\0\12\10\246\0\57\27\121\0\60\27\24\0\1\27"+
    "\13\0\12\10\46\0\53\27\25\0\12\10\u01d6\0\100\27\12\10\25\0"+
    "\1\27\u01c0\0\71\27\u0507\0\u0399\27\u0c67\0\u042f\27\u33d1\0\u0239\27\7\0"+
    "\37\27\1\0\12\10\146\0\36\27\22\0\60\27\20\0\4\27\14\0"+
    "\12\10\11\0\25\27\5\0\23\27\u0370\0\105\27\13\0\1\27\102\0"+
    "\15\27\u4060\0\2\27\u0bfe\0\153\27\5\0\15\27\3\0\11\27\7\0"+
    "\12\27\u1766\0\125\27\1\0\107\27\1\0\2\27\2\0\1\27\2\0"+
    "\2\27\2\0\4\27\1\0\14\27\1\0\1\27\1\0\7\27\1\0"+
    "\101\27\1\0\4\27\2\0\10\27\1\0\7\27\1\0\34\27\1\0"+
    "\4\27\1\0\5\27\1\0\1\27\3\0\7\27\1\0\u0154\27\2\0"+
    "\31\27\1\0\31\27\1\0\37\27\1\0\31\27\1\0\37\27\1\0"+
    "\31\27\1\0\37\27\1\0\31\27\1\0\37\27\1\0\31\27\1\0"+
    "\10\27\2\0\62\10\u1000\0\305\27\u053b\0\4\27\1\0\33\27\1\0"+
    "\2\27\1\0\1\27\2\0\1\27\1\0\12\27\1\0\4\27\1\0"+
    "\1\27\1\0\1\27\6\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\3\27\1\0\2\27\1\0\1\27\2\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\1\27\1\0\2\27\1\0"+
    "\1\27\2\0\4\27\1\0\7\27\1\0\4\27\1\0\4\27\1\0"+
    "\1\27\1\0\12\27\1\0\21\27\5\0\3\27\1\0\5\27\1\0"+
    "\21\27\u1144\0\ua6d7\27\51\0\u1035\27\13\0\336\27\u3fe2\0\u021e\27\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05f0\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\3\2\1\3\7\4\1\5\3\4\2\5"+
    "\1\4\2\5\1\3\1\5\1\4\3\5\6\0\2\4"+
    "\2\5\3\4\2\0\1\5\3\0\2\5\1\0\2\5"+
    "\11\0\1\6\12\0\2\5\1\0\2\5\22\0\2\5"+
    "\3\0\2\4\1\0\2\4\1\5\1\0\1\5\11\0"+
    "\1\7\1\0\1\4\10\0\1\10\1\4\1\0\1\4"+
    "\2\0\4\4\1\0\6\4";

  private static int [] zzUnpackAction() {
    int [] result = new int[145];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\106\0\214\0\322\0\106\0\u0118\0\u015e\0\u01a4"+
    "\0\u01ea\0\106\0\u0230\0\322\0\u0276\0\u02bc\0\u0302\0\u0348"+
    "\0\u038e\0\u03d4\0\u041a\0\u0460\0\u04a6\0\u04ec\0\u0532\0\u0578"+
    "\0\u05be\0\u0604\0\u064a\0\u0690\0\106\0\u06d6\0\u071c\0\u0762"+
    "\0\u01ea\0\u07a8\0\u07a8\0\u07ee\0\u0834\0\u087a\0\u08c0\0\u0906"+
    "\0\u094c\0\u0992\0\u09d8\0\u0a1e\0\u0a64\0\u0aaa\0\u0af0\0\u0b36"+
    "\0\u0b7c\0\u0bc2\0\u0c08\0\u0c4e\0\u05be\0\u0c94\0\u0cda\0\u0d20"+
    "\0\u0d66\0\u0dac\0\u0df2\0\u0e38\0\u0e7e\0\u071c\0\u0ec4\0\u0f0a"+
    "\0\u0f50\0\u0f96\0\u0fdc\0\u1022\0\u1068\0\u10ae\0\u10f4\0\u113a"+
    "\0\u1180\0\u11c6\0\u120c\0\u1252\0\u1298\0\u12de\0\u1324\0\u136a"+
    "\0\u13b0\0\u13f6\0\u143c\0\u1482\0\u14c8\0\u150e\0\u1554\0\u159a"+
    "\0\u15e0\0\u1626\0\u166c\0\u16b2\0\u16f8\0\u173e\0\u1784\0\u17ca"+
    "\0\u1810\0\u1856\0\u189c\0\u18e2\0\u1928\0\u196e\0\u19b4\0\u19fa"+
    "\0\u1a40\0\u1a86\0\u1acc\0\u1b12\0\u1b58\0\u1b9e\0\u1be4\0\u1c2a"+
    "\0\u1c70\0\u1cb6\0\u1cfc\0\u1d42\0\u1d88\0\u1dce\0\u1a40\0\u1e14"+
    "\0\u1e5a\0\u1ea0\0\u1ee6\0\u1f2c\0\u1f72\0\u1fb8\0\u1ffe\0\u2044"+
    "\0\322\0\u208a\0\u20d0\0\u2116\0\u215c\0\u21a2\0\u2044\0\u120c"+
    "\0\u21e8\0\u222e\0\u2274\0\u22ba\0\u2300\0\u2346\0\u238c\0\u23d2"+
    "\0\u2418";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[145];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\4\1\6\1\7\1\10"+
    "\1\11\1\12\1\10\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\1\21\1\22\1\16\1\22\1\13\1\10\1\23"+
    "\1\24\1\22\1\25\2\26\1\23\2\13\1\27\2\13"+
    "\1\30\2\26\1\13\1\31\1\32\2\33\1\34\2\33"+
    "\1\26\1\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\6\1\13\1\26\1\33\1\26\1\33"+
    "\1\35\2\0\1\35\1\0\1\35\1\36\4\35\3\0"+
    "\1\35\3\0\3\35\1\0\10\35\5\0\3\35\10\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\3\0"+
    "\1\4\211\0\1\35\2\0\1\35\1\0\1\6\1\36"+
    "\4\35\3\0\1\35\3\0\3\35\1\0\10\35\2\0"+
    "\1\27\2\0\3\35\10\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\6\1\0"+
    "\1\35\1\0\1\35\7\0\1\37\77\0\1\35\2\0"+
    "\1\35\1\0\1\35\1\36\1\10\2\35\1\10\1\13"+
    "\2\0\1\35\3\13\3\35\1\13\1\10\1\35\1\10"+
    "\5\35\2\13\1\0\2\13\3\35\1\13\7\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\13\1\35\1\0\1\35\1\0\1\35"+
    "\2\0\1\35\1\0\1\35\1\40\1\35\1\11\2\41"+
    "\2\42\1\0\1\35\2\42\1\0\3\35\1\0\1\41"+
    "\7\35\1\0\1\42\3\0\3\35\1\0\1\43\6\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\10\0"+
    "\1\13\2\0\2\13\3\0\3\13\3\0\2\13\1\0"+
    "\1\13\5\0\2\13\1\0\2\13\3\0\1\13\32\0"+
    "\1\13\21\0\1\15\70\0\1\35\2\0\1\35\1\0"+
    "\1\35\1\36\1\35\1\44\2\35\3\0\1\16\1\45"+
    "\1\46\1\0\3\16\1\0\1\16\2\35\1\16\4\35"+
    "\5\0\3\35\1\0\1\47\6\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\10\0\1\13\1\47\1\0"+
    "\2\13\2\0\1\45\1\17\1\50\1\13\3\45\1\13"+
    "\1\17\1\0\1\13\1\45\4\0\2\13\1\0\2\13"+
    "\3\0\1\13\1\47\31\0\1\13\13\0\1\13\2\0"+
    "\2\13\2\0\1\45\1\17\1\51\1\21\3\45\2\13"+
    "\1\0\1\13\1\45\4\0\2\13\1\0\2\13\3\0"+
    "\1\13\21\0\2\52\7\0\1\13\2\52\11\0\1\13"+
    "\2\0\2\13\3\0\3\13\1\53\2\0\2\13\1\0"+
    "\1\13\5\0\2\13\1\0\2\13\3\0\1\13\32\0"+
    "\1\13\4\0\1\35\2\0\1\35\1\0\1\35\1\36"+
    "\1\35\1\44\2\35\3\0\1\16\1\45\1\46\1\0"+
    "\1\22\1\16\1\22\1\0\1\16\2\23\1\22\4\23"+
    "\5\0\3\23\1\0\1\47\6\54\1\23\1\54\1\23"+
    "\1\54\1\23\1\54\1\23\1\54\1\23\1\54\1\23"+
    "\1\54\1\23\1\54\1\23\1\54\1\23\1\54\1\35"+
    "\1\0\1\23\1\54\1\23\1\54\1\35\2\0\1\35"+
    "\1\0\1\35\1\36\4\35\3\0\1\35\3\0\1\23"+
    "\1\35\1\23\1\0\1\35\7\23\5\0\3\23\2\0"+
    "\6\54\1\23\1\54\1\23\1\54\1\23\1\54\1\23"+
    "\1\54\1\23\1\54\1\23\1\54\1\23\1\54\1\23"+
    "\1\54\1\23\1\54\1\35\1\0\1\23\1\54\1\23"+
    "\1\54\1\35\2\0\1\35\1\0\1\35\1\36\1\10"+
    "\2\35\1\10\1\13\2\0\1\35\3\13\1\23\1\35"+
    "\1\23\1\13\1\10\1\23\1\24\5\23\2\13\1\0"+
    "\2\13\3\23\1\13\1\0\6\54\1\23\1\54\1\23"+
    "\1\54\1\23\1\54\1\23\1\54\1\23\1\54\1\23"+
    "\1\54\1\23\1\54\1\23\1\54\1\23\1\54\1\35"+
    "\1\13\1\23\1\54\1\23\1\54\1\55\2\0\1\55"+
    "\1\0\1\55\1\56\4\55\3\57\1\55\3\57\1\26"+
    "\1\55\1\26\1\57\1\55\4\26\1\60\2\26\2\57"+
    "\2\0\1\57\3\26\2\57\1\33\1\61\4\33\1\26"+
    "\1\33\1\26\1\33\1\26\1\33\1\26\1\33\1\26"+
    "\1\33\1\26\1\33\1\26\1\33\1\26\1\33\1\26"+
    "\1\33\1\35\1\62\1\26\1\33\1\26\1\33\1\55"+
    "\2\0\1\55\1\0\1\55\1\56\4\55\3\57\1\55"+
    "\3\57\1\26\1\55\1\26\1\57\1\55\7\26\2\57"+
    "\2\0\1\57\3\26\2\57\6\33\1\26\1\33\1\26"+
    "\1\33\1\26\1\33\1\26\1\33\1\26\1\33\1\26"+
    "\1\33\1\26\1\33\1\26\1\33\1\26\1\33\1\35"+
    "\1\62\1\26\1\33\1\26\1\33\5\0\1\27\32\0"+
    "\1\27\37\0\1\27\5\0\1\55\2\0\1\55\1\0"+
    "\1\55\1\56\4\55\3\57\1\55\3\57\1\26\1\55"+
    "\1\26\1\57\1\55\7\26\2\57\2\0\1\57\1\63"+
    "\2\26\2\57\3\33\1\64\2\33\1\26\1\33\1\26"+
    "\1\33\1\26\1\33\1\26\1\33\1\26\1\33\1\26"+
    "\1\33\1\26\1\33\1\26\1\33\1\26\1\33\1\35"+
    "\1\62\1\26\1\33\1\26\1\33\1\57\2\0\1\57"+
    "\1\0\1\57\1\65\1\57\1\31\4\65\2\57\2\65"+
    "\5\57\1\65\10\57\1\65\2\0\5\57\1\31\30\57"+
    "\1\0\1\62\5\57\2\0\1\57\1\0\15\57\1\33"+
    "\1\57\1\33\2\57\4\33\1\61\2\33\2\57\2\0"+
    "\1\57\3\33\2\57\1\33\1\61\26\33\1\0\1\62"+
    "\4\33\1\57\2\0\1\57\1\0\15\57\1\33\1\57"+
    "\1\33\2\57\7\33\2\57\2\0\1\57\3\33\2\57"+
    "\30\33\1\0\1\62\4\33\1\57\2\0\1\57\1\0"+
    "\15\57\1\33\1\57\1\33\2\57\7\33\2\57\2\0"+
    "\1\57\1\64\2\33\2\57\3\33\1\64\24\33\1\0"+
    "\1\62\4\33\1\35\2\0\1\35\1\0\1\35\1\0"+
    "\4\35\3\0\1\35\3\0\3\35\1\0\10\35\5\0"+
    "\3\35\10\0\1\66\1\67\1\70\1\71\1\35\1\0"+
    "\1\72\1\73\1\74\1\75\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\7\0\1\76\77\0\1\35\2\0\1\35\1\0"+
    "\1\35\1\42\1\35\1\11\2\41\2\42\1\0\1\35"+
    "\2\42\1\0\3\35\1\0\1\41\7\35\1\0\1\42"+
    "\3\0\3\35\1\0\1\43\6\0\1\66\1\67\1\70"+
    "\1\71\1\35\1\0\1\72\1\73\1\74\1\75\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\7\0\1\42\1\0\1\43"+
    "\4\42\2\0\2\42\5\0\1\42\10\0\1\42\7\0"+
    "\1\43\36\0\1\35\2\0\1\35\1\0\1\35\1\36"+
    "\1\35\1\44\2\35\3\0\1\35\3\0\3\35\1\0"+
    "\10\35\5\0\3\35\1\0\1\47\6\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\11\0\1\47\5\0"+
    "\2\45\1\46\1\0\3\45\1\0\1\45\2\0\1\45"+
    "\15\0\1\47\46\0\1\47\7\0\1\46\26\0\1\47"+
    "\46\0\1\47\36\0\1\47\45\0\1\13\1\47\1\0"+
    "\2\13\3\0\1\13\1\50\1\13\3\0\2\13\1\0"+
    "\1\13\5\0\2\13\1\0\2\13\3\0\1\13\1\47"+
    "\31\0\1\13\13\0\1\13\2\0\2\13\2\0\1\45"+
    "\1\17\1\51\1\21\3\45\2\13\1\0\1\13\1\45"+
    "\4\0\2\13\1\0\2\13\3\0\1\13\32\0\1\13"+
    "\74\0\2\77\37\0\1\100\104\0\1\54\1\0\1\54"+
    "\2\0\7\54\5\0\3\54\2\0\30\54\2\0\4\54"+
    "\1\55\2\0\1\55\1\0\1\55\1\56\4\55\3\57"+
    "\1\55\3\57\3\55\1\57\10\55\2\57\2\0\1\57"+
    "\3\55\10\57\1\55\1\57\1\55\1\57\1\55\1\57"+
    "\1\55\1\57\1\55\1\57\1\55\1\57\1\55\1\57"+
    "\1\55\1\57\1\55\1\57\1\35\1\62\1\55\1\57"+
    "\1\55\1\57\1\55\2\0\1\55\1\0\1\55\1\57"+
    "\4\55\3\57\1\55\3\57\3\55\1\57\10\55\2\57"+
    "\2\0\1\57\3\55\10\57\1\101\1\102\1\103\1\104"+
    "\1\55\1\57\1\105\1\106\1\107\1\110\1\55\1\57"+
    "\1\55\1\57\1\55\1\57\1\55\1\57\1\35\1\62"+
    "\1\55\1\57\1\55\2\57\2\0\1\57\1\0\33\57"+
    "\2\0\36\57\1\0\1\62\4\57\1\55\2\0\1\55"+
    "\1\0\1\55\1\56\4\55\3\57\1\55\3\57\1\26"+
    "\1\55\1\26\1\57\1\55\4\26\1\111\2\26\2\57"+
    "\2\0\1\57\3\26\2\57\1\33\1\112\4\33\1\26"+
    "\1\33\1\26\1\33\1\26\1\33\1\26\1\33\1\26"+
    "\1\33\1\26\1\33\1\26\1\33\1\26\1\33\1\26"+
    "\1\33\1\35\1\62\1\26\1\33\1\26\1\33\1\57"+
    "\2\0\1\57\1\0\15\57\1\33\1\57\1\33\2\57"+
    "\4\33\1\112\2\33\2\57\2\0\1\57\3\33\2\57"+
    "\1\33\1\112\26\33\1\0\1\62\4\33\1\113\2\0"+
    "\1\113\1\0\1\113\1\57\31\113\2\0\36\113\1\0"+
    "\5\113\1\55\2\0\1\55\1\0\1\55\1\56\4\55"+
    "\3\57\1\55\3\57\1\26\1\55\1\26\1\57\1\55"+
    "\7\26\2\57\2\0\1\57\1\114\2\26\2\57\3\33"+
    "\1\115\2\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\35\1\62\1\26\1\33"+
    "\1\26\1\33\1\57\2\0\1\57\1\0\15\57\1\33"+
    "\1\57\1\33\2\57\7\33\2\57\2\0\1\57\1\115"+
    "\2\33\2\57\3\33\1\115\24\33\1\0\1\62\4\33"+
    "\1\35\2\0\1\35\1\0\1\35\1\36\4\35\3\0"+
    "\1\35\3\0\3\35\1\0\10\35\5\0\3\35\10\0"+
    "\1\35\1\0\1\116\1\117\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\61\0"+
    "\2\117\24\0\1\35\2\0\1\35\1\0\1\35\1\36"+
    "\4\35\3\0\1\35\3\0\3\35\1\0\10\35\5\0"+
    "\3\35\10\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\120\1\121\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\71\0\2\121\14\0\1\35\2\0\1\35\1\0"+
    "\1\35\1\36\4\35\3\0\1\35\3\0\3\35\1\0"+
    "\10\35\5\0\3\35\10\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\122\1\123\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\67\0\2\123\16\0\1\35\2\0"+
    "\1\35\1\0\1\35\1\36\4\35\3\0\1\35\3\0"+
    "\3\35\1\0\10\35\5\0\3\35\10\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\124\1\125\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\75\0\2\125\114\0"+
    "\2\126\24\0\1\127\61\0\1\55\2\0\1\55\1\0"+
    "\1\55\1\56\4\55\3\57\1\55\3\57\3\55\1\57"+
    "\10\55\2\57\2\0\1\57\3\55\10\57\1\55\1\57"+
    "\1\130\1\131\1\55\1\57\1\55\1\57\1\55\1\57"+
    "\1\55\1\57\1\55\1\57\1\55\1\57\1\55\1\57"+
    "\1\35\1\62\1\55\1\57\1\55\2\57\2\0\1\57"+
    "\1\0\33\57\2\0\16\57\2\131\16\57\1\0\1\62"+
    "\4\57\1\55\2\0\1\55\1\0\1\55\1\56\4\55"+
    "\3\57\1\55\3\57\3\55\1\57\10\55\2\57\2\0"+
    "\1\57\3\55\10\57\1\55\1\57\1\55\1\57\1\55"+
    "\1\57\1\55\1\57\1\55\1\57\1\132\1\133\1\55"+
    "\1\57\1\55\1\57\1\55\1\57\1\35\1\62\1\55"+
    "\1\57\1\55\2\57\2\0\1\57\1\0\33\57\2\0"+
    "\26\57\2\133\6\57\1\0\1\62\4\57\1\55\2\0"+
    "\1\55\1\0\1\55\1\56\4\55\3\57\1\55\3\57"+
    "\3\55\1\57\10\55\2\57\2\0\1\57\3\55\10\57"+
    "\1\55\1\57\1\55\1\57\1\55\1\57\1\55\1\57"+
    "\1\134\1\135\1\55\1\57\1\55\1\57\1\55\1\57"+
    "\1\55\1\57\1\35\1\62\1\55\1\57\1\55\2\57"+
    "\2\0\1\57\1\0\33\57\2\0\24\57\2\135\10\57"+
    "\1\0\1\62\4\57\1\55\2\0\1\55\1\0\1\55"+
    "\1\56\4\55\3\57\1\55\3\57\3\55\1\57\10\55"+
    "\2\57\2\0\1\57\3\55\10\57\1\55\1\57\1\55"+
    "\1\57\1\55\1\57\1\55\1\57\1\55\1\57\1\55"+
    "\1\57\1\55\1\57\1\136\1\137\1\55\1\57\1\35"+
    "\1\62\1\55\1\57\1\55\2\57\2\0\1\57\1\0"+
    "\33\57\2\0\32\57\2\137\2\57\1\0\1\62\4\57"+
    "\1\55\2\0\1\55\1\0\1\55\1\56\4\55\3\57"+
    "\1\55\3\57\1\26\1\55\1\26\1\57\1\55\5\26"+
    "\1\140\1\26\2\57\2\0\1\57\3\26\2\57\2\33"+
    "\1\141\3\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\35\1\62\1\26\1\33"+
    "\1\26\1\33\1\57\2\0\1\57\1\0\15\57\1\33"+
    "\1\57\1\33\2\57\5\33\1\141\1\33\2\57\2\0"+
    "\1\57\3\33\2\57\2\33\1\141\25\33\1\0\1\62"+
    "\4\33\1\113\2\0\1\113\1\0\1\113\1\142\31\113"+
    "\2\0\36\113\1\0\5\113\1\55\2\0\1\55\1\0"+
    "\1\55\1\143\4\55\3\57\1\55\3\57\1\26\1\55"+
    "\1\26\1\57\1\55\7\26\2\57\2\0\1\57\3\26"+
    "\2\57\6\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\35\1\62\1\26\1\33"+
    "\1\26\1\33\1\57\2\0\1\57\1\0\1\57\1\144"+
    "\13\57\1\33\1\57\1\33\2\57\7\33\2\57\2\0"+
    "\1\57\3\33\2\57\30\33\1\0\1\62\4\33\1\35"+
    "\2\0\1\35\1\0\1\35\1\36\4\35\3\0\1\35"+
    "\3\0\3\35\1\0\10\35\5\0\3\35\10\0\1\35"+
    "\1\0\1\35\1\0\1\145\1\146\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\63\0\2\146"+
    "\22\0\1\35\2\0\1\35\1\0\1\35\1\36\4\35"+
    "\3\0\1\35\3\0\3\35\1\0\10\35\5\0\3\35"+
    "\10\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\145\1\146\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\73\0\2\146\12\0\1\35\2\0\1\35\1\0\1\35"+
    "\1\36\4\35\3\0\1\35\3\0\3\35\1\0\5\35"+
    "\1\145\2\35\5\0\3\35\3\0\1\146\4\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\34\0\1\146"+
    "\15\0\1\146\34\0\1\35\2\0\1\35\1\0\1\35"+
    "\1\36\4\35\3\0\1\35\3\0\3\35\1\0\10\35"+
    "\5\0\3\35\10\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\1\0\1\145\1\146\1\35\1\0\1\35"+
    "\1\0\1\35\77\0\2\146\26\0\1\14\111\0\1\147"+
    "\61\0\1\55\2\0\1\55\1\0\1\55\1\56\4\55"+
    "\3\57\1\55\3\57\3\55\1\57\10\55\2\57\2\0"+
    "\1\57\3\55\10\57\1\55\1\57\1\55\1\57\1\150"+
    "\1\151\1\55\1\57\1\55\1\57\1\55\1\57\1\55"+
    "\1\57\1\55\1\57\1\55\1\57\1\35\1\62\1\55"+
    "\1\57\1\55\2\57\2\0\1\57\1\0\33\57\2\0"+
    "\20\57\2\151\14\57\1\0\1\62\4\57\1\55\2\0"+
    "\1\55\1\0\1\55\1\56\4\55\3\57\1\55\3\57"+
    "\3\55\1\57\10\55\2\57\2\0\1\57\3\55\10\57"+
    "\1\55\1\57\1\55\1\57\1\55\1\57\1\55\1\57"+
    "\1\55\1\57\1\55\1\57\1\150\1\151\1\55\1\57"+
    "\1\55\1\57\1\35\1\62\1\55\1\57\1\55\2\57"+
    "\2\0\1\57\1\0\33\57\2\0\30\57\2\151\4\57"+
    "\1\0\1\62\4\57\1\55\2\0\1\55\1\0\1\55"+
    "\1\56\4\55\3\57\1\55\3\57\3\55\1\57\5\55"+
    "\1\150\2\55\2\57\2\0\1\57\3\55\3\57\1\151"+
    "\4\57\1\55\1\57\1\55\1\57\1\55\1\57\1\55"+
    "\1\57\1\55\1\57\1\55\1\57\1\55\1\57\1\55"+
    "\1\57\1\55\1\57\1\35\1\62\1\55\1\57\1\55"+
    "\2\57\2\0\1\57\1\0\26\57\1\151\4\57\2\0"+
    "\7\57\1\151\26\57\1\0\1\62\4\57\1\55\2\0"+
    "\1\55\1\0\1\55\1\56\4\55\3\57\1\55\3\57"+
    "\3\55\1\57\10\55\2\57\2\0\1\57\3\55\10\57"+
    "\1\55\1\57\1\55\1\57\1\55\1\57\1\55\1\57"+
    "\1\55\1\57\1\55\1\57\1\55\1\57\1\55\1\57"+
    "\1\150\1\151\1\35\1\62\1\55\1\57\1\55\2\57"+
    "\2\0\1\57\1\0\33\57\2\0\34\57\2\151\1\0"+
    "\1\62\4\57\1\55\2\0\1\55\1\0\1\55\1\56"+
    "\4\55\3\57\1\55\3\57\1\26\1\55\1\26\1\57"+
    "\1\55\6\26\1\152\1\153\1\57\2\0\1\57\2\26"+
    "\1\152\2\57\5\33\1\154\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\26\1\33\1\35\1\62"+
    "\1\26\1\33\1\26\1\33\1\57\2\0\1\57\1\0"+
    "\15\57\1\33\1\57\1\33\2\57\6\33\1\154\1\153"+
    "\1\57\2\0\1\57\2\33\1\154\2\57\5\33\1\154"+
    "\22\33\1\0\1\62\4\33\1\113\2\0\1\113\1\0"+
    "\1\113\1\57\23\113\3\155\3\113\2\0\1\113\3\155"+
    "\2\113\30\155\1\0\1\113\4\155\1\156\2\0\1\156"+
    "\1\0\1\156\1\57\5\156\2\57\22\156\2\0\1\57"+
    "\13\156\2\157\2\160\2\156\2\161\2\162\10\156\1\163"+
    "\1\164\5\156\2\0\1\156\1\0\1\156\1\57\5\156"+
    "\2\57\22\156\2\0\1\57\35\156\1\163\1\164\4\156"+
    "\1\35\2\0\1\35\1\0\1\35\1\36\4\35\3\0"+
    "\1\35\3\0\3\35\1\0\10\35\1\0\1\165\3\0"+
    "\3\35\10\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\1\0\1\35\1\0\1\35\1\0\1\35\1\0"+
    "\1\35\40\0\1\165\73\0\1\166\60\0\1\55\2\0"+
    "\1\55\1\0\1\55\1\56\4\55\3\57\1\55\3\57"+
    "\3\55\1\57\10\55\1\57\1\165\2\0\1\57\3\55"+
    "\10\57\1\55\1\57\1\55\1\57\1\55\1\57\1\55"+
    "\1\57\1\55\1\57\1\55\1\57\1\55\1\57\1\55"+
    "\1\57\1\55\1\57\1\35\1\62\1\55\1\57\1\55"+
    "\2\57\2\0\1\57\1\0\32\57\1\165\2\0\36\57"+
    "\1\0\1\62\4\57\1\55\2\0\1\55\1\0\1\55"+
    "\1\56\4\55\3\57\1\55\3\57\1\26\1\55\1\26"+
    "\1\57\1\55\7\26\1\153\1\57\2\0\1\57\3\26"+
    "\2\57\6\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\26\1\33\1\26\1\33"+
    "\1\26\1\33\1\26\1\33\1\35\1\62\1\26\1\33"+
    "\1\26\1\33\1\57\2\0\1\57\1\0\32\57\1\167"+
    "\2\0\36\57\1\0\1\62\5\57\2\0\1\57\1\0"+
    "\15\57\1\33\1\57\1\33\2\57\7\33\1\153\1\57"+
    "\2\0\1\57\3\33\2\57\30\33\1\0\1\62\4\33"+
    "\1\113\2\0\1\113\1\0\1\113\1\142\23\113\3\170"+
    "\3\113\2\0\1\113\3\170\2\113\30\170\1\0\1\113"+
    "\4\170\1\156\2\0\1\156\1\0\1\156\1\171\5\156"+
    "\2\57\22\156\2\0\1\57\35\156\1\163\1\164\5\156"+
    "\2\0\1\156\1\0\1\156\1\171\5\156\2\57\22\156"+
    "\2\0\1\57\15\156\2\172\16\156\1\163\1\164\5\156"+
    "\2\0\1\156\1\0\1\156\1\171\5\156\2\57\22\156"+
    "\2\0\1\57\25\156\2\173\6\156\1\163\1\164\5\156"+
    "\2\0\1\156\1\0\1\156\1\171\5\156\2\57\22\156"+
    "\2\0\1\57\23\156\2\174\10\156\1\163\1\164\5\156"+
    "\2\0\1\156\1\0\1\156\1\171\5\156\2\57\22\156"+
    "\2\0\1\57\31\156\2\175\2\156\1\163\1\164\4\156"+
    "\1\163\2\0\1\163\1\0\1\163\1\176\5\163\2\0"+
    "\22\163\3\0\43\163\1\177\2\0\1\177\1\0\1\177"+
    "\1\171\5\177\2\113\22\177\2\0\1\113\35\177\1\163"+
    "\5\177\1\200\2\0\1\200\1\0\33\200\2\0\44\200"+
    "\20\0\1\201\65\0\1\113\2\0\1\113\1\0\1\113"+
    "\1\142\23\113\3\202\3\113\2\0\1\113\3\202\2\113"+
    "\30\202\1\0\1\113\4\202\1\156\2\0\1\156\1\0"+
    "\1\156\1\57\5\156\2\57\14\156\3\203\3\156\2\0"+
    "\1\57\3\203\2\156\30\203\1\163\1\164\4\203\1\156"+
    "\2\0\1\156\1\0\1\156\1\171\5\156\2\57\22\156"+
    "\2\0\1\57\17\156\2\204\14\156\1\163\1\164\5\156"+
    "\2\0\1\156\1\0\1\156\1\171\5\156\2\57\22\156"+
    "\2\0\1\57\27\156\2\204\4\156\1\163\1\164\5\156"+
    "\2\0\1\156\1\0\1\156\1\171\5\156\2\57\15\156"+
    "\1\204\4\156\2\0\1\57\6\156\1\204\26\156\1\163"+
    "\1\164\5\156\2\0\1\156\1\0\1\156\1\171\5\156"+
    "\2\57\22\156\2\0\1\57\33\156\2\204\1\163\1\164"+
    "\4\156\1\163\2\0\1\163\1\0\1\163\1\0\5\163"+
    "\2\0\14\163\3\205\3\163\3\0\3\205\2\163\30\205"+
    "\2\163\4\205\1\177\2\0\1\177\1\0\1\177\1\206"+
    "\5\177\2\113\22\177\2\0\1\113\35\177\1\163\5\177"+
    "\1\207\2\0\1\207\1\0\1\207\1\200\5\207\2\200"+
    "\2\207\1\200\17\207\2\0\1\200\43\207\1\113\2\0"+
    "\1\113\1\0\1\113\1\142\23\113\3\210\3\113\2\0"+
    "\1\113\3\210\2\113\30\210\1\0\1\113\4\210\1\156"+
    "\2\0\1\156\1\0\1\156\1\171\5\156\2\57\14\156"+
    "\3\211\3\156\2\0\1\57\3\211\2\156\30\211\1\163"+
    "\1\164\4\211\1\156\2\0\1\156\1\0\1\156\1\171"+
    "\5\156\2\57\21\156\1\165\2\0\1\57\35\156\1\163"+
    "\1\164\4\156\1\163\2\0\1\163\1\0\1\163\1\176"+
    "\5\163\2\0\14\163\3\212\3\163\3\0\3\212\2\163"+
    "\30\212\2\163\4\212\1\177\2\0\1\177\1\0\1\177"+
    "\1\57\5\177\2\113\14\177\3\213\3\177\2\0\1\113"+
    "\3\213\2\177\30\213\1\163\1\177\4\213\1\156\2\0"+
    "\1\156\1\0\1\156\1\171\5\156\2\57\14\156\3\214"+
    "\2\156\1\165\2\0\1\57\3\214\2\156\30\214\1\163"+
    "\1\164\4\214\1\163\2\0\1\163\1\0\1\163\1\176"+
    "\5\163\2\0\14\163\3\215\2\163\1\165\3\0\3\215"+
    "\2\163\30\215\2\163\4\215\1\177\2\0\1\177\1\0"+
    "\1\177\1\206\5\177\2\113\14\177\3\216\3\177\2\0"+
    "\1\113\3\216\2\177\30\216\1\163\1\177\4\216\1\156"+
    "\2\0\1\156\1\0\1\156\1\171\5\156\2\57\14\156"+
    "\3\204\2\156\1\165\2\0\1\57\3\204\2\156\30\204"+
    "\1\163\1\164\4\204\1\163\2\0\1\163\1\0\1\163"+
    "\1\176\5\163\2\0\14\163\3\217\2\163\1\165\3\0"+
    "\3\217\2\163\30\217\2\163\4\217\1\177\2\0\1\177"+
    "\1\0\1\177\1\206\5\177\2\113\14\177\3\220\2\177"+
    "\1\165\2\0\1\113\3\220\2\177\30\220\1\163\1\177"+
    "\4\220\1\163\2\0\1\163\1\0\1\163\1\176\5\163"+
    "\2\0\21\163\1\165\3\0\43\163\1\177\2\0\1\177"+
    "\1\0\1\177\1\206\5\177\2\113\14\177\3\221\2\177"+
    "\1\165\2\0\1\113\3\221\2\177\30\221\1\163\1\177"+
    "\4\221\1\177\2\0\1\177\1\0\1\177\1\206\5\177"+
    "\2\113\21\177\1\165\2\0\1\113\35\177\1\163\5\177";

  private static int [] zzUnpackTrans() {
    int [] result = new int[9310];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\2\1\1\11\7\1\1\11\20\1\6\0\7\1"+
    "\2\0\1\1\3\0\2\1\1\0\2\1\11\0\1\1"+
    "\12\0\2\1\1\0\2\1\22\0\2\1\3\0\2\1"+
    "\1\0\3\1\1\0\1\1\11\0\1\1\1\0\1\1"+
    "\10\0\1\11\1\1\1\0\1\1\2\0\4\1\1\0"+
    "\6\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[145];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
 private LexedTokenFactory<?> tokenFactory;
 private boolean invertible;
 private CoreLabel prevWord;
 private StringBuilder prevWordAfter;
 
 // Convert Arabic digits to ASCII digits
 private boolean normArDigits;
 
 // Convert Arabic punctuation to ASCII equivalents
 private boolean normArPunc;
 
 // Substitute newlines with newlineChar.
 // Otherwise, treat them like whitespace
 private boolean tokenizeNLs;
 public static final String NEWLINE_TOKEN = "*NL*";

 // Use \u2026 for ellipses
 private boolean useUTF8Ellipsis;
 
 // Arabic-specific orthographic normalization rules
 private boolean normAlif;
 private boolean normYa;
 private boolean removeDiacritics;
 private boolean removeTatweel;
 private boolean removeQuranChars;
 
 // Penn ATB vocalized section normalizations
 private boolean removeProMarker;
 private boolean removeSegMarker;
 private boolean removeMorphMarker;
 
 // Lengthening effects (yAAAAAAA): replace three or more of the same character with one
 private boolean removeLengthening;

 private final Pattern segmentationMarker = Pattern.compile("^-+|-+$");
 
 // Escape parens for ATB parsing
 private boolean atbEscaping;

 private Map<String,String> normMap;
 
 public ArabicLexer(Reader r, LexedTokenFactory<?> tf, Properties props) {
   this(r);
   this.tokenFactory = tf;
   
   tokenizeNLs = PropertiesUtils.getBool(props, "tokenizeNLs", false);
   useUTF8Ellipsis = PropertiesUtils.getBool(props, "useUTF8Ellipsis", false);
   invertible = PropertiesUtils.getBool(props, "invertible", false);
   normArDigits = PropertiesUtils.getBool(props, "normArDigits", false);
   normArPunc = PropertiesUtils.getBool(props, "normArPunc", false);
   normAlif = PropertiesUtils.getBool(props, "normAlif", false);
   normYa = PropertiesUtils.getBool(props, "normYa", false);
   removeDiacritics = PropertiesUtils.getBool(props, "removeDiacritics", false);
   removeTatweel = PropertiesUtils.getBool(props, "removeTatweel", false);
   removeQuranChars = PropertiesUtils.getBool(props, "removeQuranChars", false);
   removeProMarker = PropertiesUtils.getBool(props, "removeProMarker", false);
   removeSegMarker = PropertiesUtils.getBool(props, "removeSegMarker", false);
   removeMorphMarker = PropertiesUtils.getBool(props, "removeMorphMarker", false);
   removeLengthening = PropertiesUtils.getBool(props, "removeLengthening", false);
   atbEscaping = PropertiesUtils.getBool(props, "atbEscaping", false);

   setupNormalizationMap();

   if (invertible) {
     if (!(tf instanceof CoreLabelTokenFactory)) {
       throw new IllegalArgumentException("ArabicLexer: the invertible option requires a CoreLabelTokenFactory");
     }
     prevWord = (CoreLabel) tf.makeToken("", 0, 0);
     prevWordAfter = new StringBuilder();
   }
 }

 private void setupNormalizationMap() {
   normMap = Generics.newHashMap(200);

   // Junk characters that we always remove
   normMap.put("\u0600","#");
   normMap.put("\u0601","");
   normMap.put("\u0602","");
   normMap.put("\u0603","");
   normMap.put("\u0606","\u221B");
   normMap.put("\u0607","\u221C");
   normMap.put("\u0608","");
   normMap.put("\u0609","%");
   normMap.put("\u060A","%");
   normMap.put("\u060B","");
   normMap.put("\u060E","");
   normMap.put("\u060F","");
   normMap.put("\u066E","\u0628");
   normMap.put("\u066F","\u0642");
   normMap.put("\u06CC","\u0649");
   normMap.put("\u06D6","");
   normMap.put("\u06D7","");
   normMap.put("\u06D8","");
   normMap.put("\u06D9","");
   normMap.put("\u06DA","");
   normMap.put("\u06DB","");
   normMap.put("\u06DC","");
   normMap.put("\u06DD","");
   normMap.put("\u06DE","");
   normMap.put("\u06DF","");
   normMap.put("\u06E0","");
   normMap.put("\u06E1","");
   normMap.put("\u06E2","");
   normMap.put("\u06E3","");
   normMap.put("\u06E4","");
   normMap.put("\u06E5","");
   normMap.put("\u06E6","");
   normMap.put("\u06E7","");
   normMap.put("\u06E8","");
   normMap.put("\u06E9","");
   normMap.put("\u06EA","");
   normMap.put("\u06EB","");
   normMap.put("\u06EC","");
   normMap.put("\u06ED","");

   if (normArDigits) {
      normMap.put("\u0660","0");
      normMap.put("\u0661","1");
      normMap.put("\u0662","2");
      normMap.put("\u0663","3");
      normMap.put("\u0664","4");
      normMap.put("\u0665","5");
      normMap.put("\u0666","6");
      normMap.put("\u0667","7");
      normMap.put("\u0668","8");
      normMap.put("\u0669","9");
      normMap.put("\u06F0","0");
      normMap.put("\u06F1","1");
      normMap.put("\u06F2","2");
      normMap.put("\u06F3","3");
      normMap.put("\u06F4","4");
      normMap.put("\u06F5","5");
      normMap.put("\u06F6","6");
      normMap.put("\u06F7","7");
      normMap.put("\u06F8","8");
      normMap.put("\u06F9","9");
   }
   if (normArPunc) {
      normMap.put("\u00BB","\"");
      normMap.put("\u00AB","\"");
      normMap.put("\u060C",",");
      normMap.put("\u060D",",");
      normMap.put("\u061B",";");
      normMap.put("\u061E",".");
      normMap.put("\u061F","?");
      normMap.put("\u066A","%");
      normMap.put("\u066B",",");
      normMap.put("\u066C","\u0027");
      normMap.put("\u066F","*");
      normMap.put("\u06DF",".");
   }
   if (normAlif) {
      normMap.put("\u0622","\u0627");
      normMap.put("\u0623","\u0627");
      normMap.put("\u0625","\u0627");
      normMap.put("\u0671","\u0627");
      normMap.put("\u0672","\u0627");
      normMap.put("\u0673","\u0627");
   }
   if (normYa) {
      normMap.put("\u064A","\u0649");
   }
   if (removeDiacritics) {
      normMap.put("\u064B","");
      normMap.put("\u064C","");
      normMap.put("\u064D","");
      normMap.put("\u064E","");
      normMap.put("\u064F","");
      normMap.put("\u0650","");
      normMap.put("\u0651","");
      normMap.put("\u0652","");
      normMap.put("\u0653","");
      normMap.put("\u0654","");
      normMap.put("\u0655","");
      normMap.put("\u0656","");
      normMap.put("\u0657","");
      normMap.put("\u0658","");
      normMap.put("\u0659","");
      normMap.put("\u065A","");
      normMap.put("\u065B","");
      normMap.put("\u065C","");
      normMap.put("\u065D","");
      normMap.put("\u065E","");
      normMap.put("\u0670","");
   }
   if (removeTatweel) {
      normMap.put("\u0640","");
      normMap.put("_","");
   }
   if (removeQuranChars) {
      // Arabic honorifics
      normMap.put("\u0610","");
      normMap.put("\u0611","");
      normMap.put("\u0612","");
      normMap.put("\u0613","");
      normMap.put("\u0614","");
      normMap.put("\u0615","");
      normMap.put("\u0616","");
      normMap.put("\u0617","");
      normMap.put("\u0618","");
      normMap.put("\u0619","");
      normMap.put("\u061A","");
   }
   if (atbEscaping) {
      normMap.put("(","-LRB-");
      normMap.put(")","-RRB-");
   }
 }

 private String normalizeToken(String text, boolean isWord) {
   // Remove segmentation markers from the ATB
   if (isWord && removeSegMarker) {
     text = segmentationMarker.matcher(text).replaceAll("");
   }
   int len = text.length();
   StringBuilder sb = new StringBuilder(len);
   for (int i = 0; i < len; ++i) {
     String thisChar = String.valueOf(text.charAt(i));
     // Remove morpheme markers from the ATB vocalized section
     if (isWord && removeMorphMarker && thisChar.equals("+")) {
       continue;
     }
     if (removeLengthening && isLengthening(text, i)) {
       continue;
     }
     if (normMap.containsKey(thisChar)) {
       thisChar = normMap.get(thisChar);
     }
     if (thisChar.length() > 0) {
       sb.append(thisChar);
     }
   }
   return sb.toString();
 }
 
 private boolean isLengthening(String text, int pos) {
   if (pos == 0) return false;
   String thisChar = String.valueOf(text.charAt(pos));
   if (!thisChar.equals(String.valueOf(text.charAt(pos - 1))))
     return false;
   if (pos < text.length() - 1 && thisChar.equals(String.valueOf(text.charAt(pos + 1))))
     return true;
   if (pos >= 2 && thisChar.equals(String.valueOf(text.charAt(pos - 2))))
     return true;
   return false;
 }
 
   /** Make the next token.
   *
   *  @param txt What the token should be
   *  @param originalText The original String that got transformed into txt
   */
  private Object getNext(String txt, String originalText) {
    if (tokenFactory == null) {
      throw new RuntimeException(this.getClass().getName() + ": Token factory is null.");
    }
    if (invertible) {
      String str = prevWordAfter.toString();
      prevWordAfter.setLength(0);
      CoreLabel word = (CoreLabel) tokenFactory.makeToken(txt, yychar, yylength());
      word.set(CoreAnnotations.OriginalTextAnnotation.class, originalText);
      word.set(CoreAnnotations.BeforeAnnotation.class, str);
      prevWord.set(CoreAnnotations.AfterAnnotation.class, str);
      prevWord = word;
      return word;
    } else {
      return tokenFactory.makeToken(txt, yychar, yylength());
    }
  }
  
  private Object getNext(boolean isWord) {
    String text = yytext();
    String normText = normalizeToken(text, isWord);
    return getNext(normText, text);
  }

  private Object getEllipsis() {
    String ellipsisString = useUTF8Ellipsis ? "\u2026" : "...";
    return getNext(ellipsisString, yytext());
  }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  ArabicLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2708) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Object next() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                if (invertible) {
                String str = prevWordAfter.toString();
                prevWord.set(CoreAnnotations.AfterAnnotation.class, str);
                prevWordAfter.setLength(0);
              }
              return null;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { System.err.printf("Untokenizable: %s%n", yytext());
	      return getNext(true);
            }
          case 9: break;
          case 2: 
            { if (tokenizeNLs) {
                return getNext(NEWLINE_TOKEN, yytext());
              } else if (invertible) {
                prevWordAfter.append(yytext());
              }
            }
          case 10: break;
          case 3: 
            { if (invertible) {
                prevWordAfter.append(yytext());
              }
            }
          case 11: break;
          case 4: 
            { return getNext(false);
            }
          case 12: break;
          case 5: 
            { return getNext(true);
            }
          case 13: break;
          case 6: 
            { return getEllipsis();
            }
          case 14: break;
          case 7: 
            { if (! removeProMarker) {
               return getNext(false);
             } else if (invertible) {
               prevWordAfter.append(yytext());
             }
            }
          case 15: break;
          case 8: 
            { if (removeProMarker) {
                if ( ! removeSegMarker) {
                  return getNext("-", yytext());
                } else if (invertible) {
                  prevWordAfter.append(yytext());
                }
              } else {
                return getNext(false);
              }
            }
          case 16: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
