/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.ArrayList;

public class TreeCollinizer
implements TreeTransformer {
    private final TreebankLanguagePack tlp;
    private final boolean deletePunct;
    private final boolean fixCollinsBaseNP;
    private final int whOption;

    public TreeCollinizer(TreebankLanguagePack tlp) {
        this(tlp, true, false);
    }

    public TreeCollinizer(TreebankLanguagePack tlp, boolean deletePunct, boolean fixCollinsBaseNP) {
        this(tlp, deletePunct, fixCollinsBaseNP, 0);
    }

    public TreeCollinizer(TreebankLanguagePack tlp, boolean deletePunct, boolean fixCollinsBaseNP, int whOption) {
        this.tlp = tlp;
        this.deletePunct = deletePunct;
        this.fixCollinsBaseNP = fixCollinsBaseNP;
        this.whOption = whOption;
    }

    public String toString() {
        return "TreeCollinizer(tlp: " + this.tlp.getClass() + ", deletePunct: " + this.deletePunct + ", fixCollinsBaseNP: " + this.fixCollinsBaseNP + ", whOption: " + this.whOption + ")";
    }

    @Override
    public Tree transformTree(Tree tree) {
        Tree[] kids;
        if (tree == null) {
            return null;
        }
        TreeFactory tf = tree.treeFactory();
        String s = tree.value();
        if (this.tlp.isStartSymbol(s)) {
            return this.transformTree(tree.firstChild());
        }
        if (tree.isLeaf()) {
            return tf.newLeaf(tree.label());
        }
        s = this.tlp.basicCategory(s);
        if ((this.whOption & 1) != 0 && s.startsWith("WH")) {
            s = s.substring(2);
        }
        if ((this.whOption & 2) != 0) {
            s = s.replaceAll("^WP", "PRP");
            s = s.replaceAll("^WDT", "DT");
            s = s.replaceAll("^WRB", "RB");
        }
        if ((this.whOption & 4) != 0 && s.startsWith("WH")) {
            s = s.substring(2);
        }
        if (this.deletePunct && tree.isPreTerminal() && (this.tlp.isEvalBIgnoredPunctuationTag(s) || this.tlp.isPunctuationWord(tree.firstChild().value()))) {
            return null;
        }
        if (this.fixCollinsBaseNP && s.equals("NP") && (kids = tree.children()).length == 1 && this.tlp.basicCategory(kids[0].value()).equals("NP")) {
            return this.transformTree(kids[0]);
        }
        if (s.equals("PRT")) {
            s = "ADVP";
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        int numKids = tree.numChildren();
        for (int cNum = 0; cNum < numKids; ++cNum) {
            Tree child = tree.children()[cNum];
            Tree newChild = this.transformTree(child);
            if (newChild == null) continue;
            children.add(newChild);
        }
        if (children.isEmpty()) {
            return null;
        }
        Tree node = tf.newTreeNode(tree.label(), children);
        node.setValue(s);
        return node;
    }
}

