// DO NOT EDIT
// Generated by JFlex 1.8.2 http://jflex.de/
// source: src/edu/stanford/nlp/international/arabic/process/ArabicLexer.flex

package edu.stanford.nlp.international.arabic.process;

import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;

/**
 * Tokenizer for UTF-8 Arabic. Supports raw text and both sections
 * (vocalized and unvocalized) of the ATB.
 *
 * @author Spence Green
 */


// See https://github.com/jflex-de/jflex/issues/222
@SuppressWarnings("FallThrough")
class ArabicLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u1100\1\u1200\1\u1300\1\u1400\1\u1100\1\u1500\1\u1600"+
    "\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u1c00\1\u1100\1\u1d00"+
    "\1\u1e00\1\u1f00\12\u2000\1\u2100\1\u2200\1\u2300\1\u2000\1\u2400"+
    "\1\u2500\2\u2000\31\u1100\1\u2600\121\u1100\1\u2700\4\u1100\1\u2800"+
    "\1\u1100\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\1\u2e00\53\u1100"+
    "\1\u2f00\10\u3000\31\u2000\1\u1100\1\u3100\1\u3200\1\u1100\1\u3300"+
    "\1\u3400\1\u3500\1\u3600\1\u2000\1\u3700\1\u3800\1\u3900\1\u3a00"+
    "\1\u1100\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u4000\1\u4100"+
    "\1\u2000\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700\1\u4800"+
    "\1\u4900\1\u4a00\1\u4b00\1\u4c00\1\u4d00\1\u2000\1\u4e00\1\u4f00"+
    "\1\u5000\1\u2000\3\u1100\1\u5100\1\u5200\1\u5300\12\u2000\4\u1100"+
    "\1\u5400\17\u2000\2\u1100\1\u5500\41\u2000\2\u1100\1\u5600\1\u5700"+
    "\2\u2000\1\u5800\1\u5900\27\u1100\1\u5a00\2\u1100\1\u5b00\45\u2000"+
    "\1\u1100\1\u5c00\1\u5d00\11\u2000\1\u5e00\27\u2000\1\u5f00\1\u6000"+
    "\1\u6100\1\u6200\11\u2000\1\u6300\1\u6400\5\u2000\1\u6500\1\u6600"+
    "\4\u2000\1\u6700\21\u2000\246\u1100\1\u6800\20\u1100\1\u6900\1\u6a00"+
    "\25\u1100\1\u6b00\34\u1100\1\u6c00\14\u2000\2\u1100\1\u6d00\u0e05\u2000";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\1\3\1\4\1\5\22\0\1\1"+
    "\1\6\1\7\5\10\2\7\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\12\16\1\17\1\10\1\7\1\10\1\7"+
    "\1\6\1\20\1\21\1\22\1\23\1\24\1\25\1\21"+
    "\1\26\1\27\3\21\1\30\1\31\1\32\1\33\1\34"+
    "\1\21\1\35\1\36\1\37\1\40\1\21\1\41\3\21"+
    "\1\42\1\43\1\44\1\10\1\45\1\10\1\21\1\22"+
    "\1\23\1\24\1\25\1\21\1\26\1\27\3\21\1\30"+
    "\1\31\1\32\1\33\1\34\1\21\1\35\1\36\1\37"+
    "\1\40\1\21\1\41\3\21\1\46\1\7\1\46\1\10"+
    "\6\0\1\3\32\0\1\47\11\10\1\50\2\10\1\50"+
    "\7\10\1\50\4\10\1\50\5\10\27\51\1\0\37\51"+
    "\1\0\207\51\1\52\u01fe\51\1\0\1\51\4\0\3\51"+
    "\1\0\3\51\1\0\1\51\1\0\24\51\1\0\337\51"+
    "\1\0\5\51\2\0\246\51\1\0\46\51\2\0\60\51"+
    "\10\0\55\51\1\0\1\51\1\0\2\51\1\0\2\51"+
    "\1\0\1\51\10\0\33\51\4\0\4\51\15\0\14\10"+
    "\1\53\1\43\15\54\5\10\1\51\43\55\1\56\1\55"+
    "\1\57\4\55\4\54\1\60\17\54\1\0\12\61\1\10"+
    "\2\43\1\10\2\55\1\54\143\55\1\10\1\55\17\54"+
    "\2\55\7\54\2\55\12\61\3\55\2\54\1\55\17\0"+
    "\243\51\16\0\12\61\54\51\4\0\1\51\5\0\26\51"+
    "\4\0\1\51\11\0\1\51\3\0\1\51\27\0\31\51"+
    "\7\0\13\51\65\0\25\51\1\0\10\51\102\0\72\51"+
    "\2\0\23\51\1\0\6\51\2\0\14\51\2\0\12\61"+
    "\1\0\23\51\1\0\10\51\2\0\2\51\2\0\26\51"+
    "\1\0\7\51\1\0\1\51\3\0\4\51\2\0\11\51"+
    "\2\0\2\51\2\0\4\51\10\0\1\51\4\0\2\51"+
    "\1\0\5\51\2\0\12\61\2\51\12\0\1\51\4\0"+
    "\3\51\1\0\6\51\4\0\2\51\2\0\26\51\1\0"+
    "\7\51\1\0\2\51\1\0\2\51\1\0\2\51\2\0"+
    "\1\51\1\0\22\51\11\0\4\51\1\0\1\51\7\0"+
    "\12\61\2\0\3\51\14\0\3\51\1\0\11\51\1\0"+
    "\3\51\1\0\26\51\1\0\7\51\1\0\2\51\1\0"+
    "\5\51\2\0\25\51\17\0\2\51\4\0\12\61\11\0"+
    "\1\51\13\0\10\51\2\0\2\51\2\0\26\51\1\0"+
    "\7\51\1\0\2\51\1\0\5\51\3\0\1\51\36\0"+
    "\2\51\1\0\3\51\4\0\12\61\1\0\1\51\20\0"+
    "\2\51\1\0\6\51\3\0\3\51\1\0\4\51\3\0"+
    "\2\51\1\0\1\51\1\0\2\51\3\0\2\51\3\0"+
    "\3\51\3\0\14\51\4\0\5\51\3\0\3\51\1\0"+
    "\4\51\2\0\1\51\25\0\12\61\21\0\3\51\1\0"+
    "\10\51\1\0\3\51\1\0\27\51\1\0\20\51\3\0"+
    "\32\51\1\0\3\51\5\0\2\51\4\0\12\61\20\0"+
    "\1\51\4\0\10\51\1\0\3\51\1\0\27\51\1\0"+
    "\12\51\1\0\5\51\3\0\1\51\40\0\1\51\1\0"+
    "\2\51\4\0\12\61\1\0\2\51\22\0\10\51\1\0"+
    "\3\51\1\0\51\51\2\0\10\51\1\0\3\51\5\0"+
    "\1\51\5\0\3\51\10\0\3\51\4\0\12\61\12\0"+
    "\6\51\5\0\22\51\3\0\30\51\1\0\11\51\1\0"+
    "\1\51\2\0\7\51\37\0\12\61\21\0\72\51\5\0"+
    "\17\51\1\0\12\61\47\0\2\51\1\0\1\51\1\0"+
    "\5\51\1\0\30\51\1\0\1\51\1\0\27\51\2\0"+
    "\5\51\1\0\1\51\1\0\6\51\2\0\12\61\2\0"+
    "\4\51\40\0\1\51\37\0\12\61\26\0\10\51\1\0"+
    "\44\51\33\0\5\51\163\0\53\51\24\0\1\51\12\61"+
    "\6\0\6\51\4\0\4\51\3\0\1\51\3\0\2\51"+
    "\7\0\3\51\4\0\15\51\14\0\1\51\1\0\12\61"+
    "\6\0\46\51\1\0\1\51\5\0\1\51\2\0\53\51"+
    "\1\0\u014d\51\1\0\4\51\2\0\7\51\1\0\1\51"+
    "\1\0\4\51\2\0\51\51\1\0\4\51\2\0\41\51"+
    "\1\0\4\51\2\0\7\51\1\0\1\51\1\0\4\51"+
    "\2\0\17\51\1\0\71\51\1\0\4\51\2\0\103\51"+
    "\45\0\20\51\20\0\126\51\2\0\6\51\3\0\u016c\51"+
    "\2\0\21\51\1\0\32\51\5\0\113\51\6\0\10\51"+
    "\7\0\15\51\1\0\4\51\16\0\22\51\16\0\22\51"+
    "\16\0\15\51\1\0\3\51\17\0\64\51\43\0\1\51"+
    "\4\0\1\51\3\0\12\61\46\0\12\61\6\0\131\51"+
    "\7\0\5\51\2\0\42\51\1\0\1\51\5\0\106\51"+
    "\12\0\37\51\47\0\12\61\36\51\2\0\5\51\13\0"+
    "\54\51\4\0\32\51\6\0\12\61\46\0\27\51\11\0"+
    "\65\51\53\0\12\61\6\0\12\61\15\0\1\51\135\0"+
    "\57\51\21\0\7\51\4\0\12\61\51\0\36\51\15\0"+
    "\2\51\12\61\54\51\32\0\44\51\34\0\12\61\3\0"+
    "\3\51\12\61\44\51\2\0\11\51\7\0\53\51\2\0"+
    "\3\51\51\0\4\51\1\0\6\51\1\0\2\51\3\0"+
    "\1\51\5\0\300\51\100\0\26\51\2\0\6\51\2\0"+
    "\46\51\2\0\6\51\2\0\10\51\1\0\1\51\1\0"+
    "\1\51\1\0\1\51\1\0\37\51\2\0\65\51\1\0"+
    "\7\51\1\0\1\51\3\0\3\51\1\0\7\51\3\0"+
    "\4\51\2\0\6\51\4\0\15\51\5\0\3\51\1\0"+
    "\7\51\3\0\13\62\5\0\30\10\2\3\5\0\1\62"+
    "\57\10\22\0\1\51\15\0\1\51\20\0\15\51\3\0"+
    "\26\10\114\0\1\51\4\0\1\51\2\0\12\51\1\0"+
    "\1\51\3\0\5\51\6\0\1\51\1\0\1\51\1\0"+
    "\1\51\1\0\4\51\1\0\13\51\2\0\4\51\5\0"+
    "\5\51\4\0\1\51\64\0\2\51\u017b\0\57\51\1\0"+
    "\57\51\1\0\205\51\6\0\4\51\3\0\2\51\14\0"+
    "\46\51\1\0\1\51\5\0\1\51\2\0\70\51\7\0"+
    "\1\51\20\0\27\51\11\0\7\51\1\0\7\51\1\0"+
    "\7\51\1\0\7\51\1\0\7\51\1\0\7\51\1\0"+
    "\7\51\1\0\7\51\117\0\1\10\1\51\320\0\1\62"+
    "\4\0\2\51\52\0\5\51\5\0\2\51\4\0\126\51"+
    "\6\0\3\51\1\0\132\51\1\0\4\51\5\0\53\51"+
    "\1\0\136\51\21\0\33\51\65\0\306\51\112\0\360\51"+
    "\20\0\215\51\103\0\56\51\2\0\15\51\3\0\20\51"+
    "\12\61\2\51\24\0\57\51\20\0\37\51\2\0\106\51"+
    "\61\0\11\51\2\0\147\51\2\0\65\51\2\0\5\51"+
    "\60\0\13\51\1\0\3\51\1\0\4\51\1\0\27\51"+
    "\35\0\64\51\16\0\62\51\34\0\12\61\30\0\6\51"+
    "\3\0\1\51\1\0\2\51\1\0\12\61\34\51\12\0"+
    "\27\51\31\0\35\51\7\0\57\51\34\0\1\51\12\61"+
    "\6\0\5\51\1\0\12\51\12\61\5\51\1\0\51\51"+
    "\27\0\3\51\1\0\10\51\4\0\12\61\6\0\27\51"+
    "\3\0\1\51\3\0\62\51\1\0\1\51\3\0\2\51"+
    "\2\0\5\51\2\0\1\51\1\0\1\51\30\0\3\51"+
    "\2\0\13\51\7\0\3\51\14\0\6\51\2\0\6\51"+
    "\2\0\6\51\11\0\7\51\1\0\7\51\1\0\53\51"+
    "\1\0\14\51\10\0\163\51\15\0\12\61\6\0\244\51"+
    "\14\0\27\51\4\0\61\51\4\0\u0100\63\156\51\2\0"+
    "\152\51\46\0\7\51\14\0\5\51\5\0\1\51\1\0"+
    "\12\51\1\0\15\51\1\0\5\51\1\0\1\51\1\0"+
    "\2\51\1\0\2\51\1\0\154\51\41\0\153\51\22\0"+
    "\100\51\2\0\66\51\50\0\14\51\164\0\5\51\1\0"+
    "\207\51\23\0\12\61\7\0\32\51\6\0\32\51\13\0"+
    "\131\51\3\0\6\51\2\0\6\51\2\0\6\51\2\0"+
    "\3\51\43\0\14\51\1\0\32\51\1\0\23\51\1\0"+
    "\2\51\1\0\17\51\2\0\16\51\42\0\173\51\205\0"+
    "\35\51\3\0\61\51\57\0\40\51\15\0\24\51\1\0"+
    "\10\51\6\0\46\51\12\0\36\51\2\0\44\51\4\0"+
    "\10\51\60\0\236\51\2\0\12\61\6\0\44\51\4\0"+
    "\44\51\4\0\50\51\10\0\64\51\234\0\67\51\11\0"+
    "\26\51\12\0\10\51\230\0\6\51\2\0\1\51\1\0"+
    "\54\51\1\0\2\51\3\0\1\51\2\0\27\51\12\0"+
    "\27\51\11\0\37\51\101\0\23\51\1\0\2\51\12\0"+
    "\26\51\12\0\32\51\106\0\70\51\6\0\2\51\100\0"+
    "\1\51\17\0\4\51\1\0\3\51\1\0\35\51\52\0"+
    "\35\51\3\0\35\51\43\0\10\51\1\0\34\51\33\0"+
    "\66\51\12\0\26\51\12\0\23\51\15\0\22\51\156\0"+
    "\111\51\67\0\63\51\15\0\63\51\15\0\44\51\14\0"+
    "\12\61\306\0\35\51\12\0\1\51\10\0\26\51\232\0"+
    "\27\51\14\0\65\51\56\0\12\61\23\0\55\51\40\0"+
    "\31\51\7\0\12\61\11\0\44\51\17\0\12\61\4\0"+
    "\1\51\13\0\43\51\3\0\1\51\14\0\60\51\16\0"+
    "\4\51\13\0\12\61\1\51\1\0\1\51\43\0\22\51"+
    "\1\0\31\51\124\0\7\51\1\0\1\51\1\0\4\51"+
    "\1\0\17\51\1\0\12\51\7\0\57\51\21\0\12\61"+
    "\13\0\10\51\2\0\2\51\2\0\26\51\1\0\7\51"+
    "\1\0\2\51\1\0\5\51\3\0\1\51\22\0\1\51"+
    "\14\0\5\51\236\0\65\51\22\0\4\51\5\0\12\61"+
    "\5\0\1\51\40\0\60\51\24\0\2\51\1\0\1\51"+
    "\10\0\12\61\246\0\57\51\51\0\4\51\44\0\60\51"+
    "\24\0\1\51\13\0\12\61\46\0\53\51\15\0\1\51"+
    "\7\0\12\61\66\0\33\51\25\0\12\61\306\0\54\51"+
    "\164\0\100\51\12\61\25\0\1\51\240\0\10\51\2\0"+
    "\47\51\20\0\1\51\1\0\1\51\34\0\1\51\12\0"+
    "\50\51\7\0\1\51\25\0\1\51\13\0\56\51\23\0"+
    "\1\51\42\0\71\51\7\0\11\51\1\0\45\51\21\0"+
    "\1\51\17\0\12\61\30\0\36\51\160\0\7\51\1\0"+
    "\2\51\1\0\46\51\25\0\1\51\11\0\12\61\6\0"+
    "\6\51\1\0\2\51\1\0\40\51\16\0\1\51\7\0"+
    "\12\61\u0136\0\23\51\15\0\232\51\346\0\304\51\274\0"+
    "\57\51\321\0\107\51\271\0\71\51\7\0\37\51\1\0"+
    "\12\61\146\0\36\51\22\0\60\51\20\0\4\51\14\0"+
    "\12\61\11\0\25\51\5\0\23\51\260\0\100\51\200\0"+
    "\113\51\5\0\1\51\102\0\15\51\100\0\2\51\1\0"+
    "\1\51\34\0\370\51\10\0\363\51\15\0\37\51\61\0"+
    "\3\51\21\0\4\51\10\0\u018c\51\4\0\153\51\5\0"+
    "\15\51\3\0\11\51\7\0\12\51\146\0\125\51\1\0"+
    "\107\51\1\0\2\51\2\0\1\51\2\0\2\51\2\0"+
    "\4\51\1\0\14\51\1\0\1\51\1\0\7\51\1\0"+
    "\101\51\1\0\4\51\2\0\10\51\1\0\7\51\1\0"+
    "\34\51\1\0\4\51\1\0\5\51\1\0\1\51\3\0"+
    "\7\51\1\0\u0154\51\2\0\31\51\1\0\31\51\1\0"+
    "\37\51\1\0\31\51\1\0\37\51\1\0\31\51\1\0"+
    "\37\51\1\0\31\51\1\0\37\51\1\0\31\51\1\0"+
    "\10\51\2\0\62\61\55\51\12\0\7\51\2\0\12\61"+
    "\4\0\1\51\u0171\0\54\51\4\0\12\61\6\0\305\51"+
    "\73\0\104\51\7\0\1\51\4\0\12\61\246\0\4\51"+
    "\1\0\33\51\1\0\2\51\1\0\1\51\2\0\1\51"+
    "\1\0\12\51\1\0\4\51\1\0\1\51\1\0\1\51"+
    "\6\0\1\51\4\0\1\51\1\0\1\51\1\0\1\51"+
    "\1\0\3\51\1\0\2\51\1\0\1\51\2\0\1\51"+
    "\1\0\1\51\1\0\1\51\1\0\1\51\1\0\1\51"+
    "\1\0\2\51\1\0\1\51\2\0\4\51\1\0\7\51"+
    "\1\0\4\51\1\0\4\51\1\0\1\51\1\0\12\51"+
    "\1\0\21\51\5\0\3\51\1\0\5\51\1\0\21\51"+
    "\104\0\327\51\51\0\65\51\13\0\336\51\2\0\u0182\51"+
    "\16\0\u0131\51\37\0\36\51\342\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[28160];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\3\3\14\4\1\2\1\4\1\5"+
    "\1\4\2\5\1\4\2\0\1\4\1\0\2\4\1\5"+
    "\7\0\1\4\1\0\1\5\2\4\1\0\2\4\1\5"+
    "\3\0\1\4\6\0\1\4\1\6\1\0\2\4\6\0"+
    "\2\4\1\0\2\4\14\0\1\4\2\0\1\4\1\0"+
    "\1\4\7\0\1\4\1\5\12\0\6\4\10\0\1\7"+
    "\1\0\1\7\3\4\2\0\1\4\1\0\1\10\4\4"+
    "\1\0\7\4";

  private static int [] zzUnpackAction() {
    int [] result = new int[148];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\64\0\150\0\234\0\64\0\320\0\u0104\0\u0138"+
    "\0\u016c\0\234\0\u01a0\0\u01d4\0\u0208\0\u023c\0\u0270\0\u02a4"+
    "\0\u02d8\0\u030c\0\u0340\0\u0374\0\u03a8\0\64\0\u03dc\0\u0410"+
    "\0\u0444\0\64\0\u0478\0\u04ac\0\u04e0\0\u0514\0\u0548\0\u057c"+
    "\0\u05b0\0\u05e4\0\u0618\0\u064c\0\u0680\0\u06b4\0\u06e8\0\u071c"+
    "\0\u0750\0\u0784\0\u07b8\0\u07ec\0\u0820\0\u0854\0\u0888\0\u08bc"+
    "\0\u08f0\0\u0924\0\u0958\0\u098c\0\u09c0\0\u09f4\0\u0a28\0\u0a5c"+
    "\0\u0a90\0\u0ac4\0\u0af8\0\u05b0\0\u0b2c\0\u064c\0\u0680\0\u0b60"+
    "\0\u0b94\0\u0bc8\0\u0bfc\0\u0c30\0\u0c64\0\u0c98\0\u0ccc\0\u0d00"+
    "\0\u08f0\0\u0924\0\u0d34\0\u0d68\0\u0d9c\0\u0dd0\0\u0e04\0\u0e38"+
    "\0\u0e6c\0\u0ea0\0\u0ed4\0\u0f08\0\u0f3c\0\u0f70\0\u0fa4\0\u0fd8"+
    "\0\u100c\0\u1040\0\u1074\0\u10a8\0\u10dc\0\u1110\0\u1144\0\u1178"+
    "\0\u11ac\0\u11e0\0\u1214\0\u1248\0\u127c\0\u12b0\0\u12e4\0\u1318"+
    "\0\u134c\0\u1380\0\u13b4\0\u13e8\0\u141c\0\u1450\0\u1484\0\u14b8"+
    "\0\u14ec\0\u1520\0\u1554\0\u1588\0\u15bc\0\u10a8\0\u15f0\0\u1624"+
    "\0\u1658\0\u168c\0\u16c0\0\u16f4\0\u1728\0\u175c\0\u1790\0\u17c4"+
    "\0\u17f8\0\u182c\0\u1860\0\u1894\0\u18c8\0\u18fc\0\u1930\0\234"+
    "\0\u1790\0\u0c30\0\u0c64\0\u1964\0\u1998\0\u19cc\0\u1a00\0\u1a34"+
    "\0\u1a68\0\u1a9c\0\u1ad0\0\u1b04";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[148];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\4\1\6\1\7\1\10"+
    "\2\11\1\12\1\13\1\14\1\11\1\15\2\11\6\16"+
    "\1\17\11\16\1\20\1\21\2\11\1\22\1\10\1\23"+
    "\1\24\2\25\1\26\1\27\3\30\1\27\1\31\1\23"+
    "\2\32\2\0\1\32\4\0\2\32\2\0\1\33\31\32"+
    "\1\0\15\32\1\0\1\3\45\0\1\3\12\0\1\3"+
    "\67\0\1\4\67\0\1\7\64\0\3\10\1\0\1\10"+
    "\1\0\1\10\1\0\2\10\21\0\5\10\1\0\1\10"+
    "\13\0\1\32\2\0\1\32\3\0\1\10\2\11\1\0"+
    "\1\10\1\33\1\11\1\32\2\11\21\32\4\11\1\10"+
    "\1\32\1\11\13\32\7\0\3\10\1\0\1\34\1\0"+
    "\1\10\1\0\2\10\7\0\1\35\4\0\1\35\4\0"+
    "\1\36\2\10\1\37\1\10\1\0\1\10\3\0\5\40"+
    "\17\0\1\41\47\0\1\42\2\0\1\42\2\0\1\43"+
    "\1\0\1\42\1\44\2\45\1\46\1\44\1\15\1\42"+
    "\1\47\21\50\1\42\1\44\1\42\1\44\1\43\1\32"+
    "\3\42\1\44\5\42\1\15\3\42\2\0\1\42\2\0"+
    "\1\43\1\0\2\42\2\43\1\51\1\42\1\50\1\42"+
    "\1\47\21\16\4\42\1\43\1\32\3\52\2\42\3\52"+
    "\1\42\1\50\3\42\2\0\1\42\2\0\1\43\1\0"+
    "\2\42\2\43\1\51\1\42\1\50\1\42\1\47\16\16"+
    "\1\53\2\16\4\42\1\43\1\32\3\52\2\42\3\52"+
    "\1\42\1\50\3\42\2\0\1\42\2\0\1\43\1\0"+
    "\2\42\2\43\1\51\1\42\1\50\1\42\1\47\20\16"+
    "\1\54\4\42\1\43\1\32\3\52\2\42\3\52\1\42"+
    "\1\50\2\42\1\32\2\0\1\32\3\0\1\10\2\11"+
    "\1\0\1\10\1\33\1\11\1\32\2\11\21\32\4\11"+
    "\1\10\1\32\1\11\6\32\1\55\5\32\2\0\1\32"+
    "\3\0\1\10\1\11\1\22\1\0\1\56\1\33\1\11"+
    "\1\57\2\11\21\32\3\11\1\22\1\10\1\32\1\11"+
    "\3\32\5\27\1\57\3\32\1\3\1\0\1\32\4\0"+
    "\2\32\2\0\1\33\31\32\1\0\1\23\12\32\1\23"+
    "\2\32\2\0\1\32\3\0\1\10\2\11\1\0\1\10"+
    "\1\33\1\11\1\32\2\11\21\25\4\11\1\10\1\32"+
    "\1\24\2\25\2\32\3\25\5\32\2\0\1\32\4\0"+
    "\2\32\2\0\1\33\4\32\21\25\4\32\1\0\1\32"+
    "\3\25\2\32\3\25\5\32\2\0\1\32\4\0\1\32"+
    "\1\27\1\0\1\60\1\33\1\32\1\57\26\32\1\27"+
    "\1\0\5\32\5\27\1\57\3\32\2\0\1\32\4\0"+
    "\1\32\1\27\1\0\1\60\1\33\1\32\1\57\2\32"+
    "\21\25\3\32\1\27\1\0\1\32\3\25\1\32\1\27"+
    "\3\30\1\27\1\57\3\32\2\0\1\32\4\0\1\32"+
    "\1\61\2\62\1\63\1\61\1\31\2\32\21\64\1\32"+
    "\1\61\1\32\1\61\1\0\4\32\1\61\5\32\1\31"+
    "\3\32\2\0\1\32\4\0\2\32\3\0\6\32\1\65"+
    "\1\32\1\66\4\32\1\67\1\70\12\32\1\0\15\32"+
    "\7\0\3\10\1\0\1\34\1\0\1\10\1\0\2\10"+
    "\21\0\1\36\2\10\1\37\1\10\1\0\1\10\3\0"+
    "\5\40\40\0\1\71\35\0\3\10\1\0\1\10\1\0"+
    "\1\10\1\0\2\10\21\0\5\10\1\0\1\10\6\0"+
    "\1\72\13\0\2\10\1\37\1\0\1\56\1\0\1\10"+
    "\1\73\2\10\21\0\3\10\1\37\1\10\1\0\1\10"+
    "\3\0\5\40\1\73\13\0\1\40\1\0\1\60\2\0"+
    "\1\73\26\0\1\40\6\0\5\40\1\73\16\0\1\74"+
    "\47\0\1\42\2\0\1\42\2\0\1\43\1\0\2\42"+
    "\2\43\1\51\3\42\1\47\25\42\1\43\1\32\14\42"+
    "\1\43\2\0\1\43\2\0\1\43\1\0\10\43\1\75"+
    "\26\43\1\0\14\43\1\42\2\0\1\42\2\0\1\43"+
    "\1\0\1\42\1\44\2\45\1\46\1\44\1\76\1\42"+
    "\1\47\22\42\1\44\1\42\1\44\1\43\1\32\3\42"+
    "\1\44\5\42\1\76\2\42\1\43\2\0\1\43\2\0"+
    "\1\43\1\0\1\43\5\45\1\77\1\43\1\75\22\43"+
    "\1\45\1\43\1\45\1\43\1\0\3\43\1\45\5\43"+
    "\1\77\2\43\1\42\2\0\1\42\2\0\1\43\1\0"+
    "\1\42\1\44\3\45\1\44\1\76\1\42\1\47\2\42"+
    "\1\100\1\42\1\101\4\42\1\102\1\103\7\42\1\44"+
    "\1\42\1\44\1\43\1\32\3\42\1\44\5\42\1\76"+
    "\2\42\1\104\2\0\1\104\2\0\1\105\1\0\2\104"+
    "\2\105\1\51\31\104\1\105\1\32\14\104\1\42\2\0"+
    "\1\42\2\0\1\43\1\0\2\42\2\43\1\51\1\42"+
    "\1\50\1\42\1\47\21\50\4\42\1\43\1\32\11\42"+
    "\1\50\3\42\2\0\1\42\2\0\1\43\1\0\2\42"+
    "\3\43\3\42\1\47\2\42\1\100\1\42\1\101\4\42"+
    "\1\102\1\103\12\42\1\43\1\32\15\42\2\0\1\42"+
    "\2\0\1\43\1\0\2\42\2\43\1\51\3\42\1\47"+
    "\21\52\4\42\1\43\1\32\3\52\2\42\3\52\5\42"+
    "\2\0\1\42\2\0\1\43\1\0\2\42\2\43\1\51"+
    "\1\42\1\50\1\42\1\47\16\16\1\106\2\16\4\42"+
    "\1\43\1\32\3\52\2\42\3\52\1\42\1\50\3\42"+
    "\2\0\1\42\2\0\1\43\1\0\2\42\2\43\1\51"+
    "\1\42\1\50\1\42\1\47\20\16\1\107\4\42\1\43"+
    "\1\32\3\52\2\42\3\52\1\42\1\50\2\42\1\32"+
    "\2\0\1\32\4\0\2\32\2\0\1\33\31\32\1\0"+
    "\11\32\1\110\3\32\7\0\3\10\1\0\1\56\1\0"+
    "\1\10\1\73\2\10\21\0\5\10\1\0\1\10\10\0"+
    "\1\73\2\0\1\32\2\0\1\32\4\0\2\32\2\0"+
    "\1\33\1\32\1\57\27\32\1\0\12\32\1\57\2\32"+
    "\13\0\1\60\2\0\1\73\42\0\1\73\2\0\1\32"+
    "\2\0\1\32\4\0\1\32\1\61\2\62\1\63\1\61"+
    "\1\111\24\32\1\61\1\32\1\61\1\0\4\32\1\61"+
    "\5\32\1\111\2\32\11\0\5\62\1\112\24\0\1\62"+
    "\1\0\1\62\5\0\1\62\5\0\1\112\2\0\1\32"+
    "\2\0\1\32\4\0\1\32\1\61\3\62\1\61\1\111"+
    "\4\32\1\65\1\32\1\66\4\32\1\67\1\70\7\32"+
    "\1\61\1\32\1\61\1\0\4\32\1\61\5\32\1\111"+
    "\3\32\2\0\1\32\4\0\2\32\2\0\1\33\1\32"+
    "\1\64\2\32\21\64\4\32\1\0\12\32\1\64\3\32"+
    "\2\0\1\32\4\0\2\32\2\0\1\33\16\32\1\113"+
    "\12\32\1\0\16\32\2\0\1\32\4\0\2\32\2\0"+
    "\1\33\7\32\1\114\21\32\1\0\16\32\2\0\1\32"+
    "\4\0\2\32\2\0\1\33\10\32\1\115\20\32\1\0"+
    "\16\32\2\0\1\32\4\0\2\32\2\0\1\33\20\32"+
    "\1\116\10\32\1\0\15\32\22\0\1\117\121\0\1\120"+
    "\21\0\1\73\42\0\1\73\2\0\1\105\2\0\1\105"+
    "\2\0\1\105\1\0\4\105\1\43\32\105\1\0\14\105"+
    "\1\42\2\0\1\42\2\0\1\43\1\0\2\42\2\43"+
    "\1\51\3\42\1\47\12\42\1\121\12\42\1\43\1\32"+
    "\15\42\2\0\1\42\2\0\1\43\1\0\2\42\2\43"+
    "\1\51\3\42\1\47\3\42\1\122\21\42\1\43\1\32"+
    "\15\42\2\0\1\42\2\0\1\43\1\0\2\42\2\43"+
    "\1\51\3\42\1\47\4\42\1\123\20\42\1\43\1\32"+
    "\15\42\2\0\1\42\2\0\1\43\1\0\2\42\2\43"+
    "\1\51\3\42\1\47\14\42\1\124\10\42\1\43\1\32"+
    "\14\42\1\104\2\0\1\104\2\0\1\105\1\0\2\104"+
    "\2\105\1\125\31\104\1\105\1\32\14\104\1\105\2\0"+
    "\1\105\2\0\1\105\1\0\4\105\1\126\32\105\1\0"+
    "\14\105\1\42\2\0\1\42\2\0\1\43\1\0\2\42"+
    "\2\43\1\51\1\42\1\50\1\42\1\47\13\16\1\127"+
    "\5\16\4\42\1\43\1\32\3\52\2\42\3\52\1\42"+
    "\1\50\3\42\2\0\1\42\2\0\1\43\1\0\2\42"+
    "\2\43\1\130\1\42\1\50\1\42\1\47\21\16\4\42"+
    "\1\43\1\32\3\52\2\42\3\52\1\42\1\50\2\42"+
    "\1\32\2\0\1\32\4\0\2\32\2\0\1\33\31\32"+
    "\1\0\7\32\1\131\6\32\2\0\1\32\4\0\2\32"+
    "\2\0\1\33\14\32\1\132\14\32\1\0\16\32\2\0"+
    "\1\32\4\0\2\32\2\0\1\33\23\32\1\132\5\32"+
    "\1\0\16\32\2\0\1\32\4\0\2\32\2\0\1\33"+
    "\22\32\1\132\6\32\1\0\16\32\2\0\1\32\4\0"+
    "\2\32\2\0\1\33\11\32\1\132\17\32\1\0\15\32"+
    "\13\0\1\12\126\0\1\133\5\0\1\42\2\0\1\42"+
    "\2\0\1\43\1\0\2\42\2\43\1\51\3\42\1\47"+
    "\10\42\1\134\14\42\1\43\1\32\15\42\2\0\1\42"+
    "\2\0\1\43\1\0\2\42\2\43\1\51\3\42\1\47"+
    "\17\42\1\134\5\42\1\43\1\32\15\42\2\0\1\42"+
    "\2\0\1\43\1\0\2\42\2\43\1\51\3\42\1\47"+
    "\16\42\1\134\6\42\1\43\1\32\15\42\2\0\1\42"+
    "\2\0\1\43\1\0\2\42\2\43\1\51\3\42\1\47"+
    "\5\42\1\134\17\42\1\43\1\32\14\42\1\104\2\0"+
    "\1\104\2\0\1\105\1\0\2\104\2\105\1\43\4\104"+
    "\2\135\1\136\1\135\1\137\4\135\1\140\1\141\6\135"+
    "\4\104\1\105\1\32\14\104\1\105\2\0\1\105\2\0"+
    "\1\105\1\0\4\105\1\43\4\105\21\142\5\105\1\0"+
    "\14\105\1\42\2\0\1\42\2\0\1\43\1\0\2\42"+
    "\2\43\1\51\1\42\1\50\1\143\1\47\15\16\1\144"+
    "\3\16\4\42\1\43\1\32\2\52\1\145\2\42\3\52"+
    "\1\42\1\50\2\42\1\146\2\0\1\146\2\0\1\43"+
    "\1\0\2\146\1\43\1\146\1\43\3\146\1\147\2\146"+
    "\1\150\1\146\1\151\4\146\1\152\1\153\12\146\1\43"+
    "\1\154\14\146\1\32\2\0\1\32\4\0\2\32\2\0"+
    "\1\33\31\32\1\0\7\32\1\155\6\32\2\0\1\32"+
    "\4\0\2\32\2\0\1\33\1\156\30\32\1\0\15\32"+
    "\56\0\1\157\5\0\1\42\2\0\1\42\2\0\1\43"+
    "\1\0\2\42\2\43\1\51\1\156\2\42\1\47\25\42"+
    "\1\43\1\32\14\42\1\104\2\0\1\104\2\0\1\105"+
    "\1\0\2\104\2\105\1\125\4\104\21\160\4\104\1\105"+
    "\1\32\15\104\2\0\1\104\2\0\1\105\1\0\2\104"+
    "\2\105\1\125\4\104\12\160\1\161\6\160\4\104\1\105"+
    "\1\32\15\104\2\0\1\104\2\0\1\105\1\0\2\104"+
    "\2\105\1\125\4\104\3\160\1\162\15\160\4\104\1\105"+
    "\1\32\15\104\2\0\1\104\2\0\1\105\1\0\2\104"+
    "\2\105\1\125\4\104\4\160\1\163\14\160\4\104\1\105"+
    "\1\32\15\104\2\0\1\104\2\0\1\105\1\0\2\104"+
    "\2\105\1\125\4\104\14\160\1\164\4\160\4\104\1\105"+
    "\1\32\14\104\1\105\2\0\1\105\2\0\1\105\1\0"+
    "\4\105\1\126\4\105\21\165\5\105\1\0\14\105\1\42"+
    "\2\0\1\42\2\0\1\43\1\0\2\42\2\43\1\51"+
    "\1\166\2\42\1\47\25\42\1\43\1\32\15\42\2\0"+
    "\1\42\2\0\1\43\1\0\2\42\2\43\1\51\1\42"+
    "\1\50\1\143\1\47\21\16\4\42\1\43\1\32\3\52"+
    "\2\42\3\52\1\42\1\50\3\42\2\0\1\42\2\0"+
    "\1\43\1\0\2\42\2\43\1\51\2\42\1\143\1\47"+
    "\21\52\4\42\1\43\1\32\3\52\2\42\3\52\4\42"+
    "\1\146\2\0\1\146\2\0\1\43\1\0\2\146\1\43"+
    "\1\146\1\167\3\146\1\147\25\146\1\43\1\154\14\146"+
    "\1\170\2\0\1\170\2\0\1\105\1\0\2\170\1\105"+
    "\1\170\1\167\31\170\1\105\1\154\14\170\1\146\2\0"+
    "\1\146\2\0\1\43\1\0\2\146\1\43\1\146\1\167"+
    "\3\146\1\147\12\146\1\171\12\146\1\43\1\154\15\146"+
    "\2\0\1\146\2\0\1\43\1\0\2\146\1\43\1\146"+
    "\1\167\3\146\1\147\3\146\1\172\21\146\1\43\1\154"+
    "\15\146\2\0\1\146\2\0\1\43\1\0\2\146\1\43"+
    "\1\146\1\167\3\146\1\147\4\146\1\173\20\146\1\43"+
    "\1\154\15\146\2\0\1\146\2\0\1\43\1\0\2\146"+
    "\1\43\1\146\1\167\3\146\1\147\14\146\1\174\10\146"+
    "\1\43\1\154\14\146\1\154\2\0\1\154\4\0\2\154"+
    "\1\0\1\154\1\175\31\154\1\0\15\154\1\32\2\0"+
    "\1\32\4\0\2\32\2\0\1\33\27\32\1\176\1\32"+
    "\1\0\15\32\1\177\2\0\1\177\2\0\1\177\1\0"+
    "\54\177\44\0\1\200\17\0\1\104\2\0\1\104\2\0"+
    "\1\105\1\0\2\104\2\105\1\125\4\104\21\201\4\104"+
    "\1\105\1\32\15\104\2\0\1\104\2\0\1\105\1\0"+
    "\2\104\2\105\1\125\4\104\10\201\1\202\10\201\4\104"+
    "\1\105\1\32\15\104\2\0\1\104\2\0\1\105\1\0"+
    "\2\104\2\105\1\125\4\104\17\201\1\202\1\201\4\104"+
    "\1\105\1\32\15\104\2\0\1\104\2\0\1\105\1\0"+
    "\2\104\2\105\1\125\4\104\16\201\1\202\2\201\4\104"+
    "\1\105\1\32\15\104\2\0\1\104\2\0\1\105\1\0"+
    "\2\104\2\105\1\125\4\104\5\201\1\202\13\201\4\104"+
    "\1\105\1\32\14\104\1\105\2\0\1\105\2\0\1\105"+
    "\1\0\4\105\1\126\4\105\21\203\5\105\1\0\14\105"+
    "\1\146\2\0\1\146\2\0\1\43\1\0\2\146\1\43"+
    "\1\146\1\43\3\146\1\147\21\204\4\146\1\43\1\154"+
    "\14\146\1\170\2\0\1\170\2\0\1\105\1\0\2\170"+
    "\1\105\1\170\1\205\31\170\1\105\1\154\14\170\1\146"+
    "\2\0\1\146\2\0\1\43\1\0\2\146\1\43\1\146"+
    "\1\167\3\146\1\147\10\146\1\206\14\146\1\43\1\154"+
    "\15\146\2\0\1\146\2\0\1\43\1\0\2\146\1\43"+
    "\1\146\1\167\3\146\1\147\17\146\1\206\5\146\1\43"+
    "\1\154\15\146\2\0\1\146\2\0\1\43\1\0\2\146"+
    "\1\43\1\146\1\167\3\146\1\147\16\146\1\206\6\146"+
    "\1\43\1\154\15\146\2\0\1\146\2\0\1\43\1\0"+
    "\2\146\1\43\1\146\1\167\3\146\1\147\5\146\1\206"+
    "\17\146\1\43\1\154\14\146\1\154\2\0\1\154\4\0"+
    "\2\154\1\0\1\154\1\0\4\154\21\207\4\154\1\0"+
    "\15\154\1\32\2\0\1\32\4\0\2\32\1\0\1\210"+
    "\1\33\31\32\1\0\15\32\1\211\2\0\1\211\2\0"+
    "\1\177\1\0\2\211\3\177\31\211\1\177\15\211\13\0"+
    "\1\210\50\0\1\104\2\0\1\104\2\0\1\105\1\0"+
    "\2\104\2\105\1\125\4\104\21\212\4\104\1\105\1\32"+
    "\15\104\2\0\1\104\2\0\1\105\1\0\2\104\2\105"+
    "\1\125\1\156\3\104\21\212\4\104\1\105\1\32\14\104"+
    "\1\105\2\0\1\105\2\0\1\105\1\0\4\105\1\126"+
    "\4\105\21\213\5\105\1\0\14\105\1\146\2\0\1\146"+
    "\2\0\1\43\1\0\2\146\1\43\1\146\1\167\3\146"+
    "\1\147\21\214\4\146\1\43\1\154\14\146\1\170\2\0"+
    "\1\170\2\0\1\105\1\0\2\170\1\105\1\170\1\43"+
    "\4\170\21\215\4\170\1\105\1\154\14\170\1\146\2\0"+
    "\1\146\2\0\1\43\1\0\2\146\1\43\1\146\1\167"+
    "\1\156\2\146\1\147\25\146\1\43\1\154\14\146\1\154"+
    "\2\0\1\154\4\0\2\154\1\0\1\154\1\175\4\154"+
    "\21\216\4\154\1\0\15\154\1\146\2\0\1\146\2\0"+
    "\1\43\1\0\2\146\1\43\1\146\1\167\1\156\2\146"+
    "\1\147\21\217\4\146\1\43\1\154\14\146\1\170\2\0"+
    "\1\170\2\0\1\105\1\0\2\170\1\105\1\170\1\205"+
    "\4\170\21\220\4\170\1\105\1\154\14\170\1\154\2\0"+
    "\1\154\4\0\2\154\1\0\1\154\1\175\1\156\3\154"+
    "\21\221\4\154\1\0\15\154\1\146\2\0\1\146\2\0"+
    "\1\43\1\0\2\146\1\43\1\146\1\167\1\156\2\146"+
    "\1\147\21\206\4\146\1\43\1\154\14\146\1\170\2\0"+
    "\1\170\2\0\1\105\1\0\2\170\1\105\1\170\1\205"+
    "\1\156\3\170\21\222\4\170\1\105\1\154\14\170\1\154"+
    "\2\0\1\154\4\0\2\154\1\0\1\154\1\175\1\156"+
    "\3\154\21\223\4\154\1\0\15\154\1\170\2\0\1\170"+
    "\2\0\1\105\1\0\2\170\1\105\1\170\1\205\1\156"+
    "\3\170\21\224\4\170\1\105\1\154\14\170\1\154\2\0"+
    "\1\154\4\0\2\154\1\0\1\154\1\175\1\156\30\154"+
    "\1\0\15\154\1\170\2\0\1\170\2\0\1\105\1\0"+
    "\2\170\1\105\1\170\1\205\1\156\30\170\1\105\1\154"+
    "\14\170";

  private static int [] zzUnpackTrans() {
    int [] result = new int[6968];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\2\1\1\11\5\1\1\11\17\1\2\0\1\1"+
    "\1\0\3\1\7\0\1\1\1\0\3\1\1\0\3\1"+
    "\3\0\1\1\6\0\2\1\1\0\2\1\6\0\2\1"+
    "\1\0\2\1\14\0\1\1\2\0\1\1\1\0\1\1"+
    "\7\0\2\1\12\0\6\1\10\0\1\1\1\0\4\1"+
    "\2\0\1\1\1\0\1\11\4\1\1\0\7\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[148];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
 private LexedTokenFactory<?> tokenFactory;
 private boolean invertible;
 private CoreLabel prevWord;
 private StringBuilder prevWordAfter;
 
 // Convert Arabic digits to ASCII digits
 private boolean normArDigits;
 
 // Convert Arabic punctuation to ASCII equivalents
 private boolean normArPunc;
 
 // Substitute newlines with newlineChar.
 // Otherwise, treat them like whitespace
 private boolean tokenizeNLs;
 public static final String NEWLINE_TOKEN = "*NL*";

 // Use \u2026 for ellipses
 private boolean useUTF8Ellipsis;
 
 // Arabic-specific orthographic normalization rules
 private boolean normAlif;
 private boolean normYa;
 private boolean removeDiacritics;
 private boolean removeTatweel;
 private boolean removeQuranChars;
 
 // Penn ATB vocalized section normalizations
 private boolean removeProMarker;
 private boolean removeSegMarker;
 private boolean removeMorphMarker;
 
 // Lengthening effects (yAAAAAAA): replace three or more of the same character with one
 private boolean removeLengthening;

 private final Pattern segmentationMarker = Pattern.compile("^-+|-+$");
 
 // Escape parens for ATB parsing
 private boolean atbEscaping;

 private Map<String,String> normMap;
 
 public ArabicLexer(Reader r, LexedTokenFactory<?> tf, Properties props) {
   this(r);
   this.tokenFactory = tf;
   
   tokenizeNLs = PropertiesUtils.getBool(props, "tokenizeNLs", false);
   useUTF8Ellipsis = PropertiesUtils.getBool(props, "useUTF8Ellipsis", false);
   invertible = PropertiesUtils.getBool(props, "invertible", false);
   normArDigits = PropertiesUtils.getBool(props, "normArDigits", false);
   normArPunc = PropertiesUtils.getBool(props, "normArPunc", false);
   normAlif = PropertiesUtils.getBool(props, "normAlif", false);
   normYa = PropertiesUtils.getBool(props, "normYa", false);
   removeDiacritics = PropertiesUtils.getBool(props, "removeDiacritics", false);
   removeTatweel = PropertiesUtils.getBool(props, "removeTatweel", false);
   removeQuranChars = PropertiesUtils.getBool(props, "removeQuranChars", false);
   removeProMarker = PropertiesUtils.getBool(props, "removeProMarker", false);
   removeSegMarker = PropertiesUtils.getBool(props, "removeSegMarker", false);
   removeMorphMarker = PropertiesUtils.getBool(props, "removeMorphMarker", false);
   removeLengthening = PropertiesUtils.getBool(props, "removeLengthening", false);
   atbEscaping = PropertiesUtils.getBool(props, "atbEscaping", false);

   setupNormalizationMap();

   if (invertible) {
     if (!(tf instanceof CoreLabelTokenFactory)) {
       throw new IllegalArgumentException("ArabicLexer: the invertible option requires a CoreLabelTokenFactory");
     }
     prevWord = (CoreLabel) tf.makeToken("", 0, 0);
     prevWordAfter = new StringBuilder();
   }
 }

 private void setupNormalizationMap() {
   normMap = Generics.newHashMap(200);

   // Junk characters that we always remove
   normMap.put("\u0600","#");
   normMap.put("\u0601","");
   normMap.put("\u0602","");
   normMap.put("\u0603","");
   normMap.put("\u0606","\u221B");
   normMap.put("\u0607","\u221C");
   normMap.put("\u0608","");
   normMap.put("\u0609","%");
   normMap.put("\u060A","%");
   normMap.put("\u060B","");
   normMap.put("\u060E","");
   normMap.put("\u060F","");
   normMap.put("\u066E","\u0628");
   normMap.put("\u066F","\u0642");
   normMap.put("\u06CC","\u0649");
   normMap.put("\u06D6","");
   normMap.put("\u06D7","");
   normMap.put("\u06D8","");
   normMap.put("\u06D9","");
   normMap.put("\u06DA","");
   normMap.put("\u06DB","");
   normMap.put("\u06DC","");
   normMap.put("\u06DD","");
   normMap.put("\u06DE","");
   normMap.put("\u06DF","");
   normMap.put("\u06E0","");
   normMap.put("\u06E1","");
   normMap.put("\u06E2","");
   normMap.put("\u06E3","");
   normMap.put("\u06E4","");
   normMap.put("\u06E5","");
   normMap.put("\u06E6","");
   normMap.put("\u06E7","");
   normMap.put("\u06E8","");
   normMap.put("\u06E9","");
   normMap.put("\u06EA","");
   normMap.put("\u06EB","");
   normMap.put("\u06EC","");
   normMap.put("\u06ED","");

   if (normArDigits) {
      normMap.put("\u0660","0");
      normMap.put("\u0661","1");
      normMap.put("\u0662","2");
      normMap.put("\u0663","3");
      normMap.put("\u0664","4");
      normMap.put("\u0665","5");
      normMap.put("\u0666","6");
      normMap.put("\u0667","7");
      normMap.put("\u0668","8");
      normMap.put("\u0669","9");
      normMap.put("\u06F0","0");
      normMap.put("\u06F1","1");
      normMap.put("\u06F2","2");
      normMap.put("\u06F3","3");
      normMap.put("\u06F4","4");
      normMap.put("\u06F5","5");
      normMap.put("\u06F6","6");
      normMap.put("\u06F7","7");
      normMap.put("\u06F8","8");
      normMap.put("\u06F9","9");
   }
   if (normArPunc) {
      normMap.put("\u00BB","\"");
      normMap.put("\u00AB","\"");
      normMap.put("\u060C",",");
      normMap.put("\u060D",",");
      normMap.put("\u061B",";");
      normMap.put("\u061E",".");
      normMap.put("\u061F","?");
      normMap.put("\u066A","%");
      normMap.put("\u066B",",");
      normMap.put("\u066C","\u0027");
      normMap.put("\u066F","*");
      normMap.put("\u06DF",".");
   }
   if (normAlif) {
      normMap.put("\u0622","\u0627");
      normMap.put("\u0623","\u0627");
      normMap.put("\u0625","\u0627");
      normMap.put("\u0671","\u0627");
      normMap.put("\u0672","\u0627");
      normMap.put("\u0673","\u0627");
   }
   if (normYa) {
      normMap.put("\u064A","\u0649");
   }
   if (removeDiacritics) {
      normMap.put("\u064B","");
      normMap.put("\u064C","");
      normMap.put("\u064D","");
      normMap.put("\u064E","");
      normMap.put("\u064F","");
      normMap.put("\u0650","");
      normMap.put("\u0651","");
      normMap.put("\u0652","");
      normMap.put("\u0653","");
      normMap.put("\u0654","");
      normMap.put("\u0655","");
      normMap.put("\u0656","");
      normMap.put("\u0657","");
      normMap.put("\u0658","");
      normMap.put("\u0659","");
      normMap.put("\u065A","");
      normMap.put("\u065B","");
      normMap.put("\u065C","");
      normMap.put("\u065D","");
      normMap.put("\u065E","");
      normMap.put("\u0670","");
   }
   if (removeTatweel) {
      normMap.put("\u0640","");
      normMap.put("_","");
   }
   if (removeQuranChars) {
      // Arabic honorifics
      normMap.put("\u0610","");
      normMap.put("\u0611","");
      normMap.put("\u0612","");
      normMap.put("\u0613","");
      normMap.put("\u0614","");
      normMap.put("\u0615","");
      normMap.put("\u0616","");
      normMap.put("\u0617","");
      normMap.put("\u0618","");
      normMap.put("\u0619","");
      normMap.put("\u061A","");
   }
   if (atbEscaping) {
      normMap.put("(","-LRB-");
      normMap.put(")","-RRB-");
   }
 }

 private String normalizeToken(String text, boolean isWord) {
   // Remove segmentation markers from the ATB
   if (isWord && removeSegMarker) {
     text = segmentationMarker.matcher(text).replaceAll("");
   }
   int len = text.length();
   StringBuilder sb = new StringBuilder(len);
   for (int i = 0; i < len; ++i) {
     String thisChar = String.valueOf(text.charAt(i));
     // Remove morpheme markers from the ATB vocalized section
     if (isWord && removeMorphMarker && thisChar.equals("+")) {
       continue;
     }
     if (removeLengthening && isLengthening(text, i)) {
       continue;
     }
     if (normMap.containsKey(thisChar)) {
       thisChar = normMap.get(thisChar);
     }
     if (thisChar.length() > 0) {
       sb.append(thisChar);
     }
   }
   return sb.toString();
 }
 
 private boolean isLengthening(String text, int pos) {
   if (pos == 0) return false;
   String thisChar = String.valueOf(text.charAt(pos));
   if (!thisChar.equals(String.valueOf(text.charAt(pos - 1))))
     return false;
   if (pos < text.length() - 1 && thisChar.equals(String.valueOf(text.charAt(pos + 1))))
     return true;
   if (pos >= 2 && thisChar.equals(String.valueOf(text.charAt(pos - 2))))
     return true;
   return false;
 }
 
   /** Make the next token.
   *
   *  @param txt What the token should be
   *  @param originalText The original String that got transformed into txt
   */
  private Object getNext(String txt, String originalText) {
    if (tokenFactory == null) {
      throw new RuntimeException(this.getClass().getName() + ": Token factory is null.");
    }
    if (invertible) {
      String str = prevWordAfter.toString();
      prevWordAfter.setLength(0);
      CoreLabel word = (CoreLabel) tokenFactory.makeToken(txt, Math.toIntExact(yychar), yylength());
      word.set(CoreAnnotations.OriginalTextAnnotation.class, originalText);
      word.set(CoreAnnotations.BeforeAnnotation.class, str);
      prevWord.set(CoreAnnotations.AfterAnnotation.class, str);
      prevWord = word;
      return word;
    } else {
      return tokenFactory.makeToken(txt, Math.toIntExact(yychar), yylength());
    }
  }
  
  private Object getNext(boolean isWord) {
    String text = yytext();
    String normText = normalizeToken(text, isWord);
    return getNext(normText, text);
  }

  private Object getEllipsis() {
    String ellipsisString = useUTF8Ellipsis ? "\u2026" : "...";
    return getNext(ellipsisString, yytext());
  }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  ArabicLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public Object next() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                if (invertible) {
                String str = prevWordAfter.toString();
                prevWord.set(CoreAnnotations.AfterAnnotation.class, str);
                prevWordAfter.setLength(0);
              }
              return null;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { System.err.printf("Untokenizable: %s%n", yytext());
	      return getNext(true);
            }
            // fall through
          case 9: break;
          case 2:
            { if (invertible) {
                prevWordAfter.append(yytext());
              }
            }
            // fall through
          case 10: break;
          case 3:
            { if (tokenizeNLs) {
                return getNext(NEWLINE_TOKEN, yytext());
              } else if (invertible) {
                prevWordAfter.append(yytext());
              }
            }
            // fall through
          case 11: break;
          case 4:
            { return getNext(false);
            }
            // fall through
          case 12: break;
          case 5:
            { return getNext(true);
            }
            // fall through
          case 13: break;
          case 6:
            { return getEllipsis();
            }
            // fall through
          case 14: break;
          case 7:
            { if (! removeProMarker) {
               return getNext(false);
             } else if (invertible) {
               prevWordAfter.append(yytext());
             }
            }
            // fall through
          case 15: break;
          case 8:
            { if (removeProMarker) {
                if ( ! removeSegMarker) {
                  return getNext("-", yytext());
                } else if (invertible) {
                  prevWordAfter.append(yytext());
                }
              } else {
                return getNext(false);
              }
            }
            // fall through
          case 16: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
